﻿using System;
using System.Collections.Generic;
using System.Linq;
using Mall.Common.API;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Mall.Common.Plugin;
using Newtonsoft.Json.Linq;
using Mall.Common;
using Mall.Module.Property;
using Mall.Model.Extend.Property;

namespace Mall.WebApi.Controllers.MallBase
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class PropertyController : BaseController
    {

        private readonly PropertyModule propertyModule = new PropertyModule();

        #region 同步商品
        /// <summary>
        /// 获取物料档案分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetMaterialPageList()
        {
            var requestParm = RequestParm;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(requestParm.msg.ToString());
            RB_Supplies_Material_Extend demodel = JsonConvert.DeserializeObject<RB_Supplies_Material_Extend>(requestParm.msg.ToString());

            if (requestParm.ERPEmpId <= 0) {
                return ApiResult.ParamIsNull("请传递参数");
            }

            demodel.RB_Group_Id = requestParm.ERPGroupId;
            var list = propertyModule.GetMaterialPageList(pagelist.pageIndex, pagelist.pageSize, demodel, out long count);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list.Select(x => new
            {
                x.Id,
                x.Name,
                x.CategoryId,
                x.CategoryName,
                x.BrandName,
                x.Money,
                x.Units,
                x.ImageList,
                x.Remark,
                x.SupplierName,
                x.Barcode,
                x.ReservedStock,
                x.SafetyStock,
                x.SuppliesModel,
                x.SuppliesNum,
                x.InventoryNum,
                UpdateBy = CacheManager.User.UserReidsCache.GetEmployee(x.UpdateBy)?.EmName ?? "",
                UpdateDate = x.UpdateDate.Value.ToString("yyyy-MM-dd")
            });
            return ApiResult.Success("", pagelist);
        }

        #endregion
    }
}