﻿
using Mall.Common.Enum.Finance;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VT.FW.DB;

namespace Mall.Model.Entity.Finance
{
    /// <summary>
    /// 财务流程关联表
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "FinanceConnection")]
    public class RB_FinanceFlowConnect
    {
        /// <summary>
        /// Id
        /// </summary>        
        public int ID
        {
            get;
            set;
        }
        /// <summary>
        /// 流程模板id
        /// </summary>        
        public int? FlowtemplateId
        {
            get;
            set;
        }
        /// <summary>
        /// 使用对象 当type=3时，对象为集团=0
        /// </summary>        
        public int? SuitableObjectId
        {
            get;
            set;
        }
        /// <summary>
        /// 1-公司，2-费用对象为0表示通用,3-集团  (备注：当为3时，请一定将SuitableObjectId=0)
        /// </summary>        
        public FinanceFlowConnectEnum? Type
        {
            get;
            set;
        }
        /// <summary>
        /// 状态
        /// </summary>        
        public int? Status
        {
            get;
            set;
        }
        /// <summary>
        /// 收入支出
        /// </summary>
        public int? Class
        {
            get; set;
        }
    }
}
