﻿using Mall.Common.Plugin;
using Mall.Model.Extend.Property;
using Mall.Model.Extend.User;
using Mall.Repository.Property;
using Mall.Repository.User;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Module.Property
{
    public class WarehouseOutModule
    {
        /// <summary>
        /// 商品出库申请仓储层
        /// </summary>
        private readonly RB_WarehouseOut_GoodsRepository warehouseOutRepository = new RB_WarehouseOut_GoodsRepository();

        /// <summary>
        /// 出库申请仓储层
        /// </summary>
        private readonly RB_WarehouseOut_ApplyRepository warehouseOutApplyRepository = new RB_WarehouseOut_ApplyRepository();


        /// <summary>
        /// 小程序仓储
        /// </summary>
        private readonly RB_MiniProgramRepository miniProgramRepository = new RB_MiniProgramRepository();

        /// <summary>
        /// 商户仓储
        /// </summary>
        private readonly RB_TenantRepository tenantRepository = new RB_TenantRepository();
        /// <summary>
        /// 日志
        /// </summary>
        private readonly RB_Property_LogRepository property_LogRepository = new RB_Property_LogRepository();

        #region 出库申请信息
        /// <summary>
        /// 出库申请列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_WarehouseOut_Goods_Extend> GetWarehouseOutPageList(int pageIndex, int pageSize, out long rowCount, RB_WarehouseOut_Goods_Extend query)
        {
            return warehouseOutRepository.GetWarehouseOutPageList(pageIndex, pageSize, out rowCount, query);
        }


        /// <summary>
        /// 出库申请列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_WarehouseOut_Goods_Extend> GetWarehouseOutList(RB_WarehouseOut_Goods_Extend query)
        {
            return warehouseOutRepository.GetWarehouseOutList(query);
        }




        /// <summary>
        /// 获取已出库的商品列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_WarehouseOut_Goods_Extend> GetWarehouseOutListByIds(RB_WarehouseOut_Goods_Extend query)
        {
            return warehouseOutRepository.GetWarehouseOutListByIds(query);
        }

        /// <summary>
        /// 出库申请列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_WarehouseOut_Apply_Extend> GetApplyPageList(int pageIndex, int pageSize, out long rowCount, RB_WarehouseOut_Apply_Extend query)
        {
            var list = warehouseOutApplyRepository.GetApplyPageList(pageIndex, pageSize, out rowCount, query);
            if (list != null && list.Any())
            {
                string mallBaseIds = string.Join(",", list.Where(x => x.MallBaseId > 0).Select(x => x.MallBaseId));
                string tenantIds = string.Join(",", list.Where(x => x.TenantId > 0).Select(x => x.TenantId));
                if (!string.IsNullOrWhiteSpace(mallBaseIds))
                {
                    var mallBaseList = GetMiniProgramListIds(mallBaseIds);
                    if (mallBaseList != null && mallBaseList.Any())
                    {
                        list.ForEach(x => x.MallBaseName = mallBaseList.Where(u => u.MallBaseId == x.MallBaseId).FirstOrDefault()?.MallName);
                    }
                }
                if (!string.IsNullOrWhiteSpace(tenantIds))
                {
                    var tenantList = GetTenantListByIds(tenantIds);
                    if (tenantList != null && tenantList.Any())
                    {
                        list.ForEach(x => x.TenantName = tenantList.Where(u => u.TenantId == x.TenantId).FirstOrDefault()?.Name);
                    }
                }
            }
            return list;
        }


        /// <summary>
        /// 出库申请列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_WarehouseOut_Apply_Extend> GetWarehouseOutList(RB_WarehouseOut_Apply_Extend query)
        {
            return warehouseOutApplyRepository.GetApplyList(query);
        }



        /// <summary>
        /// /新增申请
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>

        public bool AddWarehouseOut(RB_WarehouseOut_Apply_Extend model)
        {
            int applyId = 0;
            bool flag = false;

            var trans = warehouseOutApplyRepository.DbTransaction;
            try
            {
                if (model.ID == 0)
                {
                    applyId = warehouseOutApplyRepository.Insert(model, trans);

                    flag = applyId > 0;
                    if (flag)
                    {
                        if (model.WarehouseOutGoodsList != null && model.WarehouseOutGoodsList.Any())
                        {
                            model.WarehouseOutGoodsList.ForEach(x => x.ApplyId = applyId);
                            warehouseOutRepository.InsertBatch(model.WarehouseOutGoodsList, trans);
                        }
                    }
                    property_LogRepository.Insert(new Model.Entity.Property.RB_Property_Log()
                    {
                        Type = 6,
                        Content = "新增出库申请单",
                        CreateBy = model.MallUserId.Value,
                        CreateDate = DateTime.Now,
                        Id = 0,
                        MallBaseId = model.MallBaseId,
                        SourceId = applyId,
                        TenantId = model.TenantId
                    });
                }
                warehouseOutApplyRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "AddWarehouseOut");
                warehouseOutApplyRepository.DBSession.Rollback("AddWarehouseOut");
                return false;
            }
            return flag;
        }

        #endregion


        #region 小程序与商户信息
        /// <summary>
        /// 根据查询条件获取商户列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Tenant_Extend> GetTenantListByIds(string TenantIds)
        {
            return tenantRepository.GetTenantListByIds(TenantIds);
        }


        /// <summary>
        /// 根据查询条件获取小程序列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_MiniProgram_Extend> GetMiniProgramListIds(string MallBaseIds)
        {
            return miniProgramRepository.GetMiniProgramListIds(MallBaseIds);
        }
        #endregion

    }
}
