﻿using Mall.Model.Entity.Product;
using System;
using System.Collections.Generic;
using System.Text;
using System.Linq;

namespace Mall.Repository.Product
{
    /// <summary>
    /// 拼团活动阶梯团仓储层
    /// </summary>
    public class RB_Groupbuy_Activity_StepRepository : BaseRepository<RB_Groupbuy_Activity_Step>
    {
        /// <summary>
        /// 获取拼团活动阶梯价列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Groupbuy_Activity_Step_Extend> GetGroupBuyActivityListRepository(RB_Groupbuy_Activity_Step_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT *
FROM RB_Groupbuy_Activity_Step
WHERE 1=1
");
            if (query != null)
            {
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Groupbuy_Activity_Step_Extend.MallBaseId), query.MallBaseId);
                }
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Groupbuy_Activity_Step_Extend.TenantId), query.TenantId);
                }
                if (query.GoodId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Groupbuy_Activity_Step_Extend.GoodId), query.GoodId);
                }
                if (!string.IsNullOrWhiteSpace(query.GoodIds))
                {
                    builder.AppendFormat(" AND {0} IN({1}) ", nameof(RB_Groupbuy_Activity_Step_Extend.GoodId), query.GoodIds);
                }
            }
            return Get<RB_Groupbuy_Activity_Step_Extend>(builder.ToString()).ToList();
        }
    }
}
