﻿using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;

namespace Mall.Model.Entity.BaseSetUp
{
    /// <summary>
    /// 微店基础设置
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_MicroShop_Basics
    {
        public int ID { get; set; }

        /// <summary>
        /// 商户id
        /// </summary>
        public int TenantId { get; set; }

        /// <summary>
        /// 小程序id
        /// </summary>
        public int MallBaseId { get; set; }


        public int Status { get; set; }

        public DateTime CreateDate { get; set; }
        public DateTime UpdateDate { get; set; }

        /// <summary>
        /// 是否开开启 1-未开启，2-开启
        /// </summary>
        public int IsOpen { get; set; }


        /// <summary>
        /// 是否需要审核1-未开启，2-开启
        /// </summary>
        public int IsExamine { get; set; }

        /// <summary>
        /// 申请条件 0-不限，1-普通分销商，2-粉象分销商
        /// </summary>
        public int ApplyCondition { get; set; }

        /// <summary>
        /// 申请等级 对应申请条件中的分销商等级 0-为不限
        /// </summary>
        public int ApplyMemberLevel { get; set; }

        /// <summary>
        /// 1-自定义区间价格百分比，2-固定价格
        /// </summary>
        public int PriceType { get; set; }

        /// <summary>
        /// 自定义区间价格百分比
        /// </summary>
        public decimal? CustomMinPriceRate { get; set; }

        /// <summary>
        /// 自定义区间价格百分比
        /// </summary>
        public decimal? CustomMaxPriceRate { get; set; }


        /// <summary>
        /// 固定价格
        /// </summary>
        public decimal? CustomMinFixedPrice { get; set; }

        /// <summary>
        /// 固定价格
        /// </summary>
        public decimal? CustomMaxFixedPrice { get; set; }

        /// <summary>
        /// 结算方式 1-用户自提，2-系统自动现结（微信），3-转入余额
        /// </summary>
        public int SettlementType { get; set; }


        /// <summary>
        /// 最少提现
        /// </summary>
        public decimal? MinWithdrawal { get; set; }

        /// <summary>
        /// 提现上限
        /// </summary>
        public decimal? MaxWithdrawal { get; set; }


        /// <summary>
        /// 提现手续费
        /// </summary>
        public decimal? WithdrawalFree { get; set; }


        /// <summary>
        /// 申请协议
        /// </summary>
        public string ApplyAgreement { get; set; }


        /// <summary>
        /// 用户须知
        /// </summary>
        public string UserNotice { get; set; }
    }
}
