﻿using Mall.Common.Plugin;
using Mall.Model.Entity.MarketingCenter;
using Mall.Model.Entity.User;
using Mall.Model.Extend.MarketingCenter;
using Mall.Model.Extend.User;
using Mall.Model.Query;
using Mall.Repository;
using Mall.Repository.MarketingCenter;
using MySqlX.XDevAPI.Relational;
using Org.BouncyCastle.Crypto.Tls;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VT.FW.DB;

namespace Mall.Module.MarketingCenter
{
    /// <summary>
    /// 小程序自定义页面处理类
    /// </summary>
    public class MiniprogramPageTemplModule
    {
        /// <summary>
        /// 小程序自定义页面导航仓储层对象
        /// </summary>
        private readonly RB_Miniprogram_Page_Templ_DetailsRepository detailsRepository = new RB_Miniprogram_Page_Templ_DetailsRepository();

        /// <summary>
        /// 小程序自定义页面仓储层对象
        /// </summary>
        private readonly RB_Miniprogram_Page_TemplRepository pageRepository = new RB_Miniprogram_Page_TemplRepository();

        /// <summary>
        /// 小程序自定义页面分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Miniprogram_Page_Templ_Extend> GetMiniprogramPageTemplPageListModule(int pageIndex, int pageSize, out long rowCount, RB_Miniprogram_Page_Templ_Extend query)
        {
            var list = pageRepository.GetMiniprogramPageTemplPageListRepository(pageIndex, pageSize, out rowCount, query);
            if (list != null && list.Count > 0)
            {
                string pageIds = string.Join(",", list.Select(qitem => qitem.Id));
                List<RB_Miniprogram_Page_Templ_Details_Extend> details_Extends = GetMiniprogramPageTemplDetailsListModule(new RB_Miniprogram_Page_Templ_Details_Extend() { QPageTemplIDs = pageIds });
                foreach (var item in list)
                {
                    item.DetailsList = details_Extends?.Where(qitem => qitem.PageTemplID == item.Id)?.ToList();
                }
            }
            return list;
        }


        /// <summary>
        /// 小程序自定义页面列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Miniprogram_Page_Templ_Extend> GetMiniprogramPageTemplListModule(RB_Miniprogram_Page_Templ_Extend query)
        {
            var list = pageRepository.GetMiniprogramPageTemplListRepository(query);
            return list;
        }

        /// <summary>
        /// 小程序自定义页面导航列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Miniprogram_Page_Templ_Details_Extend> GetMiniprogramPageTemplDetailsListModule(RB_Miniprogram_Page_Templ_Details_Extend query)
        {
            return detailsRepository.GetMiniprogramPageTemplDetailsListRepository(query);
        }

        /// <summary>
        /// 小程序自定义页面实体
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <param name="isGetHome">是否查询首页页面</param>
        /// <returns></returns>
        public RB_Miniprogram_Page_Templ_Extend GetMiniprogramPageTemplModule(RB_Miniprogram_Page_Templ_Extend query, bool isGetHome = false)
        {
            var extModel = pageRepository.GetMiniprogramPageTemplRepository(query, isGetHome: isGetHome);
            if (extModel == null)
            {
                extModel = new RB_Miniprogram_Page_Templ_Extend();
            }
            if (extModel.Id > 0)
            {
                extModel.DetailsList = GetMiniprogramPageTemplDetailsListModule(new RB_Miniprogram_Page_Templ_Details_Extend() { QPageTemplIDs = extModel.Id.ToString() });
            }
            return extModel;
        }

        /// <summary>
        /// 新增修改自定义页面
        /// </summary>
        /// <param name="extModel"></param>
        /// <returns></returns>
        public bool SetMiniprogramPageTemplModule(RB_Miniprogram_Page_Templ_Extend extModel)
        {
            bool flag = false;
            if (extModel.Id > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_Miniprogram_Page_Templ_Extend.PageName),extModel.PageName }
                };
                fileds.Add(nameof(RB_Miniprogram_Page_Templ_Extend.IsUse), extModel.IsUse);
                fileds.Add(nameof(RB_Miniprogram_Page_Templ_Extend.IsShowNav), extModel.IsShowNav);
                fileds.Add(nameof(RB_Miniprogram_Page_Templ_Extend.IsHome), extModel.IsHome);
                flag = pageRepository.Update(fileds, new WhereHelper(nameof(RB_Miniprogram_Page_Templ_Extend.Id), extModel.Id));
            }
            else
            {
                var newId = pageRepository.Insert(extModel);
                extModel.Id = newId;
                flag = newId > 0;
            }
            if (flag && extModel.DetailsList != null && extModel.DetailsList.Count > 0)
            {
                foreach (var subItem in extModel.DetailsList)
                {
                    subItem.PageTemplID = extModel.Id;
                    if (subItem.Id > 0)
                    {
                        flag = detailsRepository.Update(subItem);
                    }
                    else
                    {
                        flag = detailsRepository.Insert(subItem) > 0;
                    }
                }
            }
            return flag;
        }

        /// <summary>
        /// 更新模板禁用、启用
        /// </summary>
        /// <param name="Id"></param>
        /// <param name="IsUse"></param>
        /// <returns></returns>
        public bool SetMiniprogramPageTemplIsUseModule(object Id, int IsUse)
        {
            bool flag = false;
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Miniprogram_Page_Templ_Extend.IsUse),IsUse }
            };
            flag = pageRepository.Update(fileds, new WhereHelper(nameof(RB_Miniprogram_Page_Templ_Extend.Id), Id));
            return flag;
        }

        /// <summary>
        /// 更新模板是否设为首页
        /// </summary>
        /// <param name="Id"></param>
        /// <param name="IsHome"></param>
        /// <param name="MallBaseId">小程序Id</param>
        /// <returns></returns>
        public bool SetMiniprogramPageTemplIsHomeModule(object Id, int IsHome,int MallBaseId)
        {
            bool flag = false;
            flag = pageRepository.UpdateIsHomeRepository(MallBaseId);
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Miniprogram_Page_Templ_Extend.IsHome),IsHome }
            };
            flag = pageRepository.Update(fileds, new WhereHelper(nameof(RB_Miniprogram_Page_Templ_Extend.Id), Id));
            return flag;
        }

        /// <summary>
        /// 更新自定义页面状态
        /// </summary>
        /// <param name="Id">编号</param>
        /// <param name="Status">状态</param>
        /// <returns></returns>
        public bool RemoveMiniprogramPageTemplModule(object Id, int Status)
        {
            bool flag = false;
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Miniprogram_Page_Templ_Extend.Status),Status }
            };
            flag = pageRepository.Update(fileds, new WhereHelper(nameof(RB_Miniprogram_Page_Templ_Extend.Id), Id));
            return flag;
        }

        /// <summary>
        /// 根据Id删除小程序自定义页面导航
        /// </summary>
        /// <param name="Id"></param>
        /// <returns></returns>
        public bool RemoveMiniprogramPageTemplDetailsModule(object Id)
        {
            bool flag = false;
            flag = detailsRepository.Delete(Id)>0;
            return flag;
        }
    }
}
