﻿using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.User
{
    /// <summary>
    /// 用户查看微信日志仓储层
    /// </summary>
    public class RB_Member_LookRepository:BaseRepository<RB_Member_Look>
    {
        /// <summary>
        /// 获取用户查看微信日志分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Member_Look_Extend> GetMemberLookPageRepository(int pageIndex, int pageSize, out long rowsCount, RB_Member_Look_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT A.* 
FROM RB_Member_Look AS A
WHERE 1=1
");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(@" AND A.{0}={1} ", nameof(RB_Member_Look_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(@" AND A.{0}={1} ", nameof(RB_Member_Look_Extend.MallBaseId), query.MallBaseId);
                }
            }
            return GetPage<RB_Member_Look_Extend>(pageIndex, pageSize, out rowsCount, builder.ToString()).ToList();
        }

        /// <summary>
        /// 获取用户查看日志列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Member_Look_Extend> GetMemberLookListRepository(  RB_Member_Look_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT A.* 
FROM RB_Member_Look AS A
WHERE 1=1
");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(@" AND A.{0}={1} ", nameof(RB_Member_Look_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(@" AND A.{0}={1} ", nameof(RB_Member_Look_Extend.MallBaseId), query.MallBaseId);
                }

                if (query.UserId > 0)
                {
                    builder.AppendFormat(@" AND A.{0}={1} ", nameof(RB_Member_Look_Extend.UserId), query.UserId);
                }
                if (query.CreateBy > 0)
                {
                    builder.AppendFormat(@" AND A.{0}={1} ", nameof(RB_Member_Look_Extend.CreateBy), query.CreateBy);
                }
                if (!string.IsNullOrEmpty(query.StartTime))
                {
                    builder.AppendFormat(@" AND A.{0} >='{1}' ", nameof(RB_Member_Look_Extend.CreateDate), query.StartTime);
                }
                if (!string.IsNullOrEmpty(query.EndTime))
                {
                    builder.AppendFormat(@" AND A.{0} <='{1} 23:59:59' ", nameof(RB_Member_Look_Extend.CreateDate), query.EndTime);
                }
            }
            return Get<RB_Member_Look_Extend>(builder.ToString()).ToList();
        }

        /// <summary>
        /// 获取当月已查看次数
        /// </summary>
        /// <param name="mallBaseId"></param>
        /// <param name="userId"></param>
        /// <param name="sTime"></param>
        /// <param name="eTime"></param>
        /// <returns></returns>
        public int GetMemberLookNum(int mallBaseId, int userId, string sTime, string eTime)
        {
            string sql = $@" select count(0) as num from RB_Member_Look where MallBaseId ={mallBaseId} and CreateBy ={userId} and CreateDate >='{sTime}' and CreateDate <='{eTime} 23:59:59'";
            var obj = ExecuteScalar(sql);
            return obj != null ? Convert.ToInt32(obj) : 0;
        }
    }
}
