﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace AdapaySDK
{
    public class FastPay
    {
        /**
         * 创建快捷支付绑卡对象
         *
         * @param requestParams  请求参数
         * @param merchantKey merchantKey
         * @return 快捷支付绑卡
         */
        public static Dictionary<string, Object> cardBind(Dictionary<string, object> requestParams)
        {
            return AdapayRequest.requestAdapay(requestParams, APIUrlEnum.FAST_PAY_CARD_BIND, null);
        }

        /**
         * 创建快捷支付绑卡确认
         *
         * @param requestParams  请求参数
         * @param merchantKey merchantKey
         * @return 快捷支付绑卡确认
         */
        public static Dictionary<string, Object> cardBindConfirm(Dictionary<string, object> requestParams)
        {
            return AdapayRequest.requestAdapay(requestParams, APIUrlEnum.FAST_PAY_CARD_BIND_CONFIRM, null);
        }

        /**
         * 查询快捷支付绑卡对象列表
         *
         * @param requestParams  请求参数
         * @param merchantKey merchantKey
         * @return 快捷支付绑卡
         */
        public static Dictionary<string, Object> cardBindList(Dictionary<string, object> requestParams)
        {
            return AdapayRequest.getRequestAdapay(requestParams, APIUrlEnum.FAST_PAY_CARD_BIND_LIST, null);
        }

        /**
         * 创建快捷支付确认
         *
         * @param requestParams  请求参数
         * @param merchantKey merchantKey
         * @return 快捷支付确认
         */
        public static Dictionary<string, Object> confirm(Dictionary<string, object> requestParams)
        {
            return AdapayRequest.requestAdapay(requestParams, APIUrlEnum.FAST_PAY_CONFIRM, null);
        }

        /**
         * 快捷支付短信重发
         *
         * @param requestParams  请求参数
         * @param merchantKey merchantKey
         * @return 快捷支付短信重发
         */
        public static Dictionary<string, Object> smsCode(Dictionary<string, object> requestParams)
        {
            return AdapayRequest.requestAdapay(requestParams, APIUrlEnum.FAST_PAY_SMS_CODE, null);
        }


        /**
         * 创建快捷支付绑卡对象
         *
         * @param requestParams  请求参数
         * @param merchantKey merchantKey
         * @return 快捷支付绑卡
         */
        public static Dictionary<string, Object> cardBind(Dictionary<string, object> requestParams, string merchantKey)
        {
            return AdapayRequest.requestAdapay(requestParams, APIUrlEnum.FAST_PAY_CARD_BIND, merchantKey);
        }

        /**
         * 创建快捷支付绑卡确认
         *
         * @param requestParams  请求参数
         * @param merchantKey merchantKey
         * @return 快捷支付绑卡确认
         */
        public static Dictionary<string, Object> cardBindConfirm(Dictionary<string, object> requestParams, string merchantKey)
        {
            return AdapayRequest.requestAdapay(requestParams, APIUrlEnum.FAST_PAY_CARD_BIND_CONFIRM, merchantKey);
        }

        /**
         * 查询快捷支付绑卡对象列表
         *
         * @param requestParams  请求参数
         * @param merchantKey merchantKey
         * @return 快捷支付绑卡
         */
        public static Dictionary<string, Object> cardBindList(Dictionary<string, object> requestParams, string merchantKey)
        {
            return AdapayRequest.getRequestAdapay(requestParams, APIUrlEnum.FAST_PAY_CARD_BIND_LIST, merchantKey);
        }

        /**
         * 创建快捷支付确认
         *
         * @param requestParams  请求参数
         * @param merchantKey merchantKey
         * @return 快捷支付确认
         */
        public static Dictionary<string, Object> confirm(Dictionary<string, object> requestParams, string merchantKey)
        {
            return AdapayRequest.requestAdapay(requestParams, APIUrlEnum.FAST_PAY_CONFIRM, merchantKey);
        }

        /**
         * 快捷支付短信重发
         *
         * @param requestParams  请求参数
         * @param merchantKey merchantKey
         * @return 快捷支付短信重发
         */
        public static Dictionary<string, Object> smsCode(Dictionary<string, object> requestParams, string merchantKey)
        {
            return AdapayRequest.requestAdapay(requestParams, APIUrlEnum.FAST_PAY_SMS_CODE, merchantKey);
        }

    }
}
