﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Common.Enum.Education;
using VT.FW.DB;

namespace Mall.Model.Entity.Coffee
{
    /// <summary>
    /// 教育商品实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "EduConnection")]
	public class RB_Goods
	{
		/// <summary>
		/// Id
		/// </summary>
		public int Id { get; set; }

		/// <summary>
		/// 商品类型  1咖啡劵   2耗材类   3教室类
		/// </summary>
		public int GoodsType { get; set; }

		/// <summary>
		/// GoodsName
		/// </summary>
		public string GoodsName { get; set; }

		/// <summary>
		/// 封面图
		/// </summary>
		public string CoverImage { get; set; }

		/// <summary>
		/// 售价
		/// </summary>
		public decimal SellingPrice { get; set; }

		/// <summary>
		/// 删除状态
		/// </summary>
		public int Status { get; set; }

		/// <summary>
		/// 商户号
		/// </summary>
		public int Group_Id { get; set; }

		/// <summary>
		/// 小程序id
		/// </summary>
		public int MallBaseId { get; set; }

		/// <summary>
		/// CreateDate
		/// </summary>
		public DateTime CreateDate { get; set; }

		/// <summary>
		/// UpdateDate
		/// </summary>
		public DateTime UpdateDate { get; set; }

		/// <summary>
		/// 对应的电商商品ID
		/// </summary>
		public int MallGoodsId { get; set; }

	}
}
