﻿using VT.FW.DB;
using Mall.Common.Enum.User;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.User
{
    /// <summary>
    /// 图片魔方表扩展实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Mall_Magic_Extend : Model.Entity.User.RB_Mall_Magic
    {
        /// <summary>
        /// 魔方数据列表
        /// </summary>
        public List<MagicItem> MagicDataList { get; set; }

        /// <summary>
        /// 创建时间字符串
        /// </summary>
        public string CreateDateStr
        {
            get
            {
                string str = "";
                if (this.CreateDate != null)
                {
                    str = Convert.ToDateTime(this.CreateDate).ToString("yyyy-MM-dd HH:mm:ss");
                }
                return str;
            }
        }
    }

    /// <summary>
    /// 魔方数据项
    /// </summary>
    public class MagicItem
    {
        /// <summary>
        /// 魔方链接
        /// </summary>
        public string Link { get; set; }

        /// <summary>
        /// 魔方图片
        /// </summary>
        public string ImgUrl { get; set; }
    }
}