﻿using Mall.Model.Entity.Product;
using Mall.Model.Extend.Product;
using System;
using System.Collections.Generic;
using System.Text;
using System.Linq;

namespace Mall.Repository.Product
{
    /// <summary>
    /// 拼团活动仓储层
    /// </summary>
    public class RB_Groupbuy_ActivityRepository : BaseRepository<RB_Groupbuy_Activity>
    {
        /// <summary>
        ///  获取拼团活动分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowsCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Groupbuy_Activity_Extend> GetGroupbuyActivityPageListRepository(int pageIndex, int pageSize, out long rowsCount, RB_Groupbuy_Activity_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT A.*,B.Name AS QGoodName,B.CarouselImage AS CarouselImage
FROM RB_Groupbuy_Activity AS A LEFT JOIN rb_goods AS B ON A.GoodId=B.Id
WHERE 1=1 
");
            if (query != null)
            {
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Groupbuy_Activity_Extend.MallBaseId), query.MallBaseId);
                }
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Groupbuy_Activity_Extend.TenantId), query.TenantId);
                }
                //时间范围
                if (!string.IsNullOrWhiteSpace(query.QStartDate) && !string.IsNullOrWhiteSpace(query.QEndDate))
                {
                    builder.AppendFormat(@" AND
                        (
                            '{0}' BETWEEN StartTime AND EndTime OR 
                            '{1}' BETWEEN StartTime AND EndTime OR 
                            StartTime BETWEEN '{0}' AND '{1}' OR
                            EndTime BETWEEN '{0}' AND '{1}'
                        )", Convert.ToDateTime(query.QStartDate).ToString("yyyy-MM-dd HH:mm:ss"), Convert.ToDateTime(query.QEndDate).ToString("yyyy-MM-dd HH:mm:ss"));
                }
                if (!string.IsNullOrWhiteSpace(query.QGoodName))
                {
                    builder.AppendFormat(@" AND B.Name LIKE '%{0}%' ", query.QGoodName);
                }
                if (query.GoodsStatus > 0)
                {
                    builder.AppendFormat(@" AND A.GoodsStatus={0} ", query.GoodsStatus);
                }
            }
            return GetPage<RB_Groupbuy_Activity_Extend>(pageIndex, pageSize, out rowsCount, builder.ToString()).ToList();
        }


        /// <summary>
        /// 获取活动实体类
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public RB_Groupbuy_Activity_Extend GetGroupbuyActivityEntityRepository(RB_Groupbuy_Activity_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT * 
FROM RB_Groupbuy_Activity
WHERE 1=1 
");
            if (query != null)
            {
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Groupbuy_Activity_Extend.MallBaseId), query.MallBaseId);
                }
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Groupbuy_Activity_Extend.TenantId), query.TenantId);
                }
                if (query.ActivityId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Groupbuy_Activity_Extend.ActivityId), query.ActivityId);
                }
            }
            return Get<RB_Groupbuy_Activity_Extend>(builder.ToString()).FirstOrDefault();
        }
    }
}