﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Mall.Common.API;
using Mall.Model.Extend.User;
using Mall.Module.User;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Mall.Common.Plugin;
using Mall.Common.Enum.User;
using Mall.CacheManager.User;
using Newtonsoft.Json.Linq;
using Mall.Common;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.Configuration.Json;
using Google.Protobuf.WellKnownTypes;

namespace Mall.WebApi.Controllers.User
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class SmallShopsController : BaseController
    {
        private readonly SmallShopsModule smallShopsModule = new SmallShopsModule();

        #region 微店管理
        /// <summary>
        /// 获取店铺分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetSmallShopsPageList()
        {
            var parms = RequestParm;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(parms.msg.ToString());
            RB_SmallShops_Info_Extend demodel = JsonConvert.DeserializeObject<RB_SmallShops_Info_Extend>(parms.msg.ToString());

            demodel.TenantId = parms.TenantId;
            demodel.MallBaseId = parms.MallBaseId;
            var list = smallShopsModule.GetSmallShopsPageList(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list.Select(x => new
            {
                x.Id,
                x.Name,
                x.Logo,
                x.UserId,
                UserName = x.NickName,
                x.Commission,
                x.TotalCommission,
                x.Notice,
                x.AuditStatus,
                AuditStatusName = x.AuditStatus.GetEnumName(),
                AuditDate = x.AuditDate.HasValue ? x.AuditDate.Value.ToString("yyyy-MM-dd HH:mm:ss") : "",
                x.Remark,
                x.TenantId,
                CreateDate = x.CreateDate.HasValue ? x.CreateDate.Value.ToString("yyyy-MM-dd HH:mm:ss") : ""
            });
            return ApiResult.Success("", pagelist);
        }

        /// <summary>
        /// 获取店铺下拉列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetSmallShopsDropDownList()
        {
            var parms = RequestParm;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(parms.msg.ToString());
            RB_SmallShops_Info_Extend demodel = JsonConvert.DeserializeObject<RB_SmallShops_Info_Extend>(parms.msg.ToString());

            demodel.TenantId = Convert.ToInt32(parms.uid);
            demodel.MallBaseId = parms.MallBaseId;
            var list = smallShopsModule.GetSmallShopsDropDownList(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list.Select(x => new
            {
                x.Id,
                x.Name
            });
            return ApiResult.Success("", pagelist);
        }

        /// <summary>
        /// 获取店铺信息
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetSmallShopsInfo()
        {
            var requestParm = RequestParm;
            var parms = JObject.Parse(requestParm.msg.ToString());
            int SmallShopsId = parms.GetInt("SmallShopsId", 0);
            if (SmallShopsId <= 0)
            {
                return ApiResult.ParamIsNull();
            }

            var model = smallShopsModule.GetSmallShopsInfo(SmallShopsId);
            if (model.TenantId != Convert.ToInt32(requestParm.uid))
            {
                return ApiResult.ParamIsNull("未查询到该微店信息");
            }
            if (model.MallBaseId != requestParm.MallBaseId)
            {
                return ApiResult.ParamIsNull("未查询到该微店信息");
            }
            return ApiResult.Success("", new
            {
                model.Id,
                model.Name,
                model.Logo,
                model.UserId,
                UserName = model.NickName,
                model.Commission,
                model.TotalCommission,
                model.Notice,
                model.AuditStatus,
                AuditStatusName = model.AuditStatus.GetEnumName(),
                AuditDate = model.AuditDate.HasValue ? model.AuditDate.Value.ToString("yyyy-MM-dd HH:mm:ss") : "",
                model.Remark,
                CreateDate = model.CreateDate.HasValue ? model.CreateDate.Value.ToString("yyyy-MM-dd HH:mm:ss") : ""
            });
        }

        /// <summary>
        /// 微店审核信息
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetSmallShopsAudit()
        {
            var req = RequestParm;
            JObject prams = JObject.Parse(req.msg.ToString());
            int SmallShopsId = prams.GetInt("SmallShopsId", 0);
            int Type = prams.GetInt("Type", 1);//类型  1审核通过   2审核拒绝  3修改备注
            string Remark = prams.GetStringValue("Remark");

            if (SmallShopsId <= 0)
            {
                return ApiResult.ParamIsNull();
            }
            var ssmodel = smallShopsModule.GetSmallShopsInfo(SmallShopsId);
            if (ssmodel == null)
            {
                return ApiResult.Failed("微店不存在");
            }
            if (ssmodel.TenantId != req.TenantId)
            {
                return ApiResult.ParamIsNull("未查询到该微店信息");
            }
            if (ssmodel.MallBaseId != req.MallBaseId)
            {
                return ApiResult.ParamIsNull("未查询到该微店信息");
            }
            if (Type == 1 || Type == 2)
            {
                if (ssmodel.AuditStatus != DistributorAuditStatusEnum.Auditing)
                {
                    return ApiResult.ParamIsNull("微店状态不正确");
                }
            }

            ssmodel.Remark = Remark;
            bool flag = smallShopsModule.SetSmallShopsAudit(ssmodel, Type);
            if (flag)
            {
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed();
            }
        }

        /// <summary>
        /// 设置微店佣金
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetSmallShopsCommission() {
            var req = RequestParm;
            JObject parms = JObject.Parse(req.msg.ToString());
            int SmallShopsId = parms.GetInt("SmallShopsId", 0);
            decimal Commission = parms.GetDecimal("Commission");

            if (SmallShopsId <= 0) {
                return ApiResult.Failed();
            }

            bool flag = smallShopsModule.SetSmallShopsCommission(SmallShopsId, Commission, req.TenantId, req.MallBaseId, req.EmpId);
            if (flag)
            {
                return ApiResult.Success();
            }
            else {
                return ApiResult.Failed();
            }
        }

        #endregion
    }
}