﻿using Mall.Common.Enum;
using System;
using VT.FW.DB;

namespace Mall.Model.Entity.TradePavilion
{
	/// <summary>
	/// 联系人实体类
	/// </summary>
	[Serializable]
	[DB(ConnectionName = "DefaultConnection")]
	public class RB_Contract
    {
		/// <summary>
		/// 主键
		/// </summary>
 
		public int Id { get; set; }

		/// <summary>
		/// 姓名
		/// </summary>
		public string Name { get; set; }

		/// <summary>
		/// 电话
		/// </summary>
		public string Tel { get; set; }

		/// <summary>
		/// 头像
		/// </summary>
		public string HeadIcon { get; set; }

		/// <summary>
		/// 背景图
		/// </summary>
		public string BgImg { get; set; }

		/// <summary>
		/// 职位
		/// </summary>
		public string Position { get; set; }

		/// <summary>
		/// 介绍
		/// </summary>
		public string Intro { get; set; }

		/// <summary>
		/// 商户号id
		/// </summary>
		public int TenantId { get; set; }

		/// <summary>
		/// 小程序id
		/// </summary>
		public int MallBaseId { get; set; }

		/// <summary>
		/// 创建人
		/// </summary>
		public int CreateBy { get; set; }

		/// <summary>
		/// 创建时间
		/// </summary>
		public DateTime CreateDate { get; set; }

		/// <summary>
		/// 修改人
		/// </summary>
		public int UpdateBy { get; set; }

		/// <summary>
		/// 修改时间
		/// </summary>
		public DateTime UpdateDate { get; set; }

		/// <summary>
		/// 删除状态
		/// </summary>
		public DateStateEnum Status { get; set; }
	}
}
