﻿using VT.FW.DB;
using Mall.Common.Enum.User;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.User
{
    /// <summary>
    /// 分销商表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Distributor_Info
    {

        /// <summary>
        /// Id
        /// </summary>        
        public int Id
        {
            get;
            set;
        }
        /// <summary>
        /// 用户id
        /// </summary>        
        public int? UserId
        {
            get;
            set;
        }
        /// <summary>
        /// 姓名
        /// </summary>        
        public string Name
        {
            get;
            set;
        }
        /// <summary>
        /// 手机号码
        /// </summary>
        public string Mobile { get; set; }
        /// <summary>
        /// 总计佣金
        /// </summary>        
        public decimal? TotalCommission
        {
            get;
            set;
        }
        /// <summary>
        /// 可提现佣金
        /// </summary>        
        public decimal? CommissionWithdrawal
        {
            get;
            set;
        }
        /// <summary>
        /// 分销商等级id
        /// </summary>        
        public int? GradeId
        {
            get;
            set;
        }
        /// <summary>
        /// 和平分销等级id
        /// </summary>
        public int? HPGradeId { get; set; }
        /// <summary>
        /// 粉象返佣等级
        /// </summary>
        public int? FXGradeId { get; set; }
        /// <summary>
        /// 审核状态  1审核中  2通过  3拒绝
        /// </summary>        
        public DistributorAuditStatusEnum? AuditStatus
        {
            get;
            set;
        }
        /// <summary>
        /// 审核时间
        /// </summary>        
        public DateTime? AuditDate
        {
            get;
            set;
        }
        /// <summary>
        /// 备注
        /// </summary>        
        public string Remark
        {
            get;
            set;
        }
        /// <summary>
        /// 删除状态
        /// </summary>        
        public int? Status
        {
            get;
            set;
        }
        /// <summary>
        /// 商户号
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }
        /// <summary>
        /// 小程序id
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }
        /// <summary>
        /// CreateDate
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }
        /// <summary>
        /// UpdateDate
        /// </summary>        
        public DateTime? UpdateDate
        {
            get;
            set;
        }

        /// <summary>
        /// 粉象Vip的有效期
        /// </summary>
        public DateTime? VipExpiryDate { get; set; }

        /// <summary>
        /// 是否开启离线收益提醒  1是 0否
        /// </summary>
        public int IsOpenOfflineEarnings { get; set; }
    }
}
