﻿using VT.FW.DB;
using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Miai;

namespace Mall.Model.Extend.Miai
{
    /// <summary>
    /// 相亲消息扩展实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Miai_Message_Extend : RB_Miai_Message
    {
        /// <summary>
        /// 查询类型  1圈子   2拼拼plus  3访客   4系统消息
        /// </summary>
        public int SelectType { get; set; }

        /// <summary>
        /// 访客类型   1谁看过我   2我看过谁
        /// </summary>
        public int VsisitorType { get; set; }

        /// <summary>
        /// 回复字段
        /// </summary>
        public object ReplyContent { get; set; }

        /// <summary>
        /// 总数量
        /// </summary>
        public int TCount { get; set; }

        /// <summary>
        /// 人数
        /// </summary>
        public int PeopleNum { get; set; }
        /// <summary>
        /// 名称
        /// </summary>
        public string Name { get; set; }
        /// <summary>
        /// 真实名称
        /// </summary>
        public string RealName { get; set; }
        /// <summary>
        /// 头像
        /// </summary>
        public string Photo { get; set; }
        /// <summary>
        /// 性别
        /// </summary>
        public int Sex { get; set; }
    }
}
