﻿using Mall.Model.Extend.TradePavilion;
using Mall.Repository.TradePavilion;
using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;

namespace Mall.Module.TradePavilion
{
    /// <summary>
    /// 韩国馆新闻处理类
    /// </summary>
    public class CommerceNewsModule
    {
        /// <summary>
        /// 韩国馆新闻仓储层对象
        /// </summary>
        private readonly RB_Commerce_NewsRepository commerce_NewsRepository = new RB_Commerce_NewsRepository();

        /// <summary>
        /// 获取新闻分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Commerce_News_Extend> GetCommerceNewsPageListModule(int pageIndex, int pageSize, out long rowsCount, RB_Commerce_News_Extend query)
        {
            return commerce_NewsRepository.GetCommerceNewsPageListRepository(pageIndex, pageSize, out rowsCount, query);
        }

        /// <summary>
        /// 新增修改新闻
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetCommerceNewsModule(RB_Commerce_News_Extend model)
        {
            bool flag;
            if (model.Id > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    { nameof(RB_Commerce_News_Extend.CoverImg),model.CoverImg},
                    { nameof(RB_Commerce_News_Extend.Type),model.Type},
                    { nameof(RB_Commerce_News_Extend.Title),model.Title},
                    { nameof(RB_Commerce_News_Extend.Industry),model.Industry},
                    { nameof(RB_Commerce_News_Extend.PublishTime),model.PublishTime},
                    { nameof(RB_Commerce_News_Extend.NewsInfo),model.NewsInfo},
                    { nameof(RB_Commerce_News_Extend.UpdateBy),model.UpdateBy},
                    { nameof(RB_Commerce_News_Extend.UpdateDate),model.UpdateDate},
                };
                flag = commerce_NewsRepository.Update(fileds, new WhereHelper(nameof(RB_Commerce_News_Extend.Id),model.Id));
            }
            else
            {
                var newId = commerce_NewsRepository.Insert(model);
                model.Id = newId;
                flag = newId > 0;
            }
            return flag;
        }

        /// <summary>
        /// 获取新闻信息实体
        /// </summary>
        /// <param name="Id"></param>
        /// <returns></returns>
        public RB_Commerce_News_Extend GetCommerceNewsModule(int Id)
        {
            return commerce_NewsRepository.GetEntity<RB_Commerce_News_Extend>(Id);
        }

        /// <summary>
        /// 更新新闻信息状态
        /// </summary>
        /// <param name="Id"></param>
        /// <param name="Status"></param>
        /// <returns></returns>
        public bool RemoveCommerceNewsModule(int Id, int Status)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Commerce_News_Extend.Status),Status },
            };
            bool flag = commerce_NewsRepository.Update(fileds, new WhereHelper(nameof(RB_Commerce_News_Extend.Id), Id));
            return flag;
        }
    }
}
