﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;
using Mall.Model.Extend.Product;
using System.Linq;
using Mall.Model.Entity.User;

namespace Mall.Repository.Product
{
    /// <summary>
    /// 活动仓储层
    /// </summary>
    public class RB_Goods_ActivityRepository : BaseRepository<RB_Goods_Activity>
    {

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Goods_Activity_Extend> GetList(RB_Goods_Activity_Extend dmodel)
        {
            string where = $" 1=1 and Status=0";
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Goods_Activity_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Goods_Activity_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (!string.IsNullOrEmpty(dmodel.ActivityName))
            {
                where += $@" and {nameof(RB_Goods_Activity_Extend.ActivityName)} like '%{dmodel.ActivityName}%'";
            }
            if (dmodel.Way > 0)
            {
                where += $@" and {nameof(RB_Goods_Activity_Extend.Way)}={dmodel.Way}";
            }
            if (dmodel.RangeType > 0)
            {
                where += $@" and {nameof(RB_Goods_Activity_Extend.RangeType)}={dmodel.RangeType}";
            }
            if (dmodel.Enable > 0)
            {
                where += $@" and {nameof(RB_Goods_Activity_Extend.Enable)}={dmodel.Enable}";
            }
            if (dmodel.QActivityState > 0)
            {
                if (dmodel.QActivityState == 1)
                {
                    //进行中
                    where += $@" and {nameof(RB_Goods_Activity_Extend.StartTime)} <='{DateTime.Now}'";
                    where += $@" and {nameof(RB_Goods_Activity_Extend.EndTime)} >='{DateTime.Now}'";
                }
                else
                {
                    //已结束
                    where += $@" and {nameof(RB_Goods_Activity_Extend.EndTime)} <'{DateTime.Now}'";
                }
            }
            if (!string.IsNullOrEmpty(dmodel.OrderTime)) {
                //进行中
                where += $@" and {nameof(RB_Goods_Activity_Extend.StartTime)} <='{dmodel.OrderTime}'";
                where += $@" and {nameof(RB_Goods_Activity_Extend.EndTime)} >='{dmodel.OrderTime}'";
                where += $@" and {nameof(RB_Goods_Activity_Extend.ReceiveTime)} >='{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}'";
            }

            string sql = $@"SELECT * FROM RB_Goods_Activity where {where} order by Id asc";
            return Get<RB_Goods_Activity_Extend>(sql).ToList();
        }


        /// <summary>
        /// 获取可兑换列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Goods_Activity_Extend> GetCanReceiveList(RB_Goods_Activity_Extend dmodel)
        {
            string where = $" 1=1 and Status =0 and Enable =1";
            where += $@" and {nameof(RB_Goods_Activity_Extend.StartTime)} <='{DateTime.Now}'";
            where += $@" and {nameof(RB_Goods_Activity_Extend.ReceiveTime)} >='{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}'";
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Goods_Activity_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Goods_Activity_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }

            string sql = $@"SELECT * FROM RB_Goods_Activity where {where} order by Id asc";
            return Get<RB_Goods_Activity_Extend>(sql).ToList();
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Goods_Activity_Extend> GetListForOrder(RB_Goods_Activity_Extend dmodel)
        {
            string where = $" 1=1 and a.Status=0 and g.Id is null";
            if (dmodel.TenantId > 0)
            {
                where += $@" and a.{nameof(RB_Goods_Activity_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and a.{nameof(RB_Goods_Activity_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Enable > 0)
            {
                where += $@" and a.{nameof(RB_Goods_Activity_Extend.Enable)}={dmodel.Enable}";
            }
            if (dmodel.OneUserId > 0)
            {
                where += $@" and g.{nameof(RB_Goods_Activity_Get_Extend.UserId)}={dmodel.OneUserId}";
            }
            if (!string.IsNullOrEmpty(dmodel.OrderTime))
            {
                //进行中
                where += $@" and a.{nameof(RB_Goods_Activity_Extend.StartTime)} <='{dmodel.OrderTime}'";
                where += $@" and a.{nameof(RB_Goods_Activity_Extend.EndTime)} >='{dmodel.OrderTime}'";
                where += $@" and a.{nameof(RB_Goods_Activity_Extend.ReceiveTime)} >='{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}'";
            }

            string sql = $@"SELECT a.* FROM RB_Goods_Activity a
left join rb_goods_activity_get g on a.Id = g.ActivityId
where {where} order by a.Id asc";
            return Get<RB_Goods_Activity_Extend>(sql).ToList();
        }

        /// <summary>
        /// 获取分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Goods_Activity_Extend> GetPageList(int pageIndex,int pageSize, out long count,RB_Goods_Activity_Extend dmodel)
        {
            string where = $" 1=1 and Status=0";
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Goods_Activity_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Goods_Activity_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (!string.IsNullOrEmpty(dmodel.ActivityName))
            {
                where += $@" and {nameof(RB_Goods_Activity_Extend.ActivityName)} like '%{dmodel.ActivityName}%'";
            }
            if (dmodel.Way > 0)
            {
                where += $@" and {nameof(RB_Goods_Activity_Extend.Way)}={dmodel.Way}";
            }
            if (dmodel.RangeType > 0)
            {
                where += $@" and {nameof(RB_Goods_Activity_Extend.RangeType)}={dmodel.RangeType}";
            }
            if (dmodel.Enable > 0)
            {
                where += $@" and {nameof(RB_Goods_Activity_Extend.Enable)}={dmodel.Enable}";
            }
            if (dmodel.QActivityState > 0) {
                if (dmodel.QActivityState == 1)
                {
                    //进行中
                    where += $@" and {nameof(RB_Goods_Activity_Extend.StartTime)} <='{DateTime.Now}'";
                    where += $@" and {nameof(RB_Goods_Activity_Extend.EndTime)} >='{DateTime.Now}'";
                }
                else {
                    //已结束
                    where += $@" and {nameof(RB_Goods_Activity_Extend.EndTime)} <'{DateTime.Now}'";
                }
            }

            string sql = $@"SELECT * FROM RB_Goods_Activity where {where} order by Id asc";
            return GetPage<RB_Goods_Activity_Extend>(pageIndex, pageSize, out count, sql).ToList();
        }
    }
}
