﻿using Mall.Model.Entity.TradePavilion;
using Mall.Model.Extend.TradePavilion;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VT.FW.DB.Dapper;

namespace Mall.Repository.TradePavilion
{
    /// <summary>
    /// 商会活动详情表仓储层
    /// </summary>
    public class RB_Commerce_DetailsRepository : BaseRepository<RB_Commerce_Details>
    {
        /// <summary>
        /// 获取商会活动详情列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Commerce_Details_Extend> GetCommerceDetailsListRepository(RB_Commerce_Details_Extend query)
        {
            DynamicParameters parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT * 
FROM RB_Commerce_Details
WHERE 1=1
");
 
            if (query == null)
            {
                return new List<RB_Commerce_Details_Extend>();
            }
            else
            {
                if (query.ActivityId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Commerce_Details_Extend.ActivityId), query.ActivityId);
                }
                if (!string.IsNullOrEmpty(query.QActivityIds))
                {
                    builder.AppendFormat(" AND {0} IN({1}) ", nameof(RB_Commerce_Details_Extend.ActivityId), query.QActivityIds);
                }
            }
            return Get<RB_Commerce_Details_Extend>(builder.ToString(), parameters).ToList();
        }

        /// <summary>
        /// 根据活动编号删除活动详情
        /// </summary>
        /// <param name="ActivityId"></param>
        /// <returns></returns>
        public bool DeleteCommerceDetailsRepository(int ActivityId)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(" DELETE FROM RB_Commerce_Details WHERE ActivityId={0} ", ActivityId);
            return base.Execute(builder.ToString()) > 0;
        }
    }
}