﻿using System;
using System.Collections.Generic;
using System.Linq;
using Mall.CacheManager.User;
using Mall.Common.API;
using Mall.Common.Plugin;
using Mall.Model.Extend.TradePavilion;
using Mall.Module.TradePavilion;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;

namespace Mall.WebApi.Controllers.TradePavilion
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class TradeController : BaseController
    {
        /// <summary>
        /// 联系人处理类对象
        /// </summary>
        private readonly ContractModule module = new ContractModule();

        /// <summary>
        /// 投资采购处理类对象
        /// </summary>
        private readonly InvestmentProcurementModule procurementModule = new InvestmentProcurementModule();

        /// <summary>
        /// 公司信息处理类对象
        /// </summary>
        private readonly CompanyModule companyModule = new CompanyModule();


        /// <summary>
        /// 商会活动处理类对象
        /// </summary>
        private readonly CommerceActivityModule activityModule = new CommerceActivityModule();

        /// <summary>
        /// 商会活动报名处理类对象
        /// </summary>
        private readonly CommerceConsultModule consultModule = new CommerceConsultModule();

        /// <summary>
        /// 韩国馆新闻处理类
        /// </summary>
        private readonly CommerceNewsModule commerceNewsModule = new CommerceNewsModule();


        /// <summary>
        /// Fat资料处理类对象
        /// </summary>
        private readonly CommerceAskModule askModule = new CommerceAskModule();

        #region 联系人管理

        /// <summary>
        /// 获取联系人分页列表
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        [AllowAnonymous]
        public ApiResult GetContractPageList()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Contract_Extend()
            {
                Name = parms.GetStringValue("Name")
            };
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = module.GetContractPageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            if (list != null && list.Count > 0)
            {
                foreach (var item in list)
                {
                    if (item.CreateBy > 0)
                    {
                        item.CreateByName = UserReidsCache.GetUserLoginInfo(item.CreateBy)?.Account ?? "";
                    }
                }
            }
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 获取联系人列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetContractList()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Contract_Extend()
            {
                Name = parms.GetStringValue("Name")
            };
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = module.GetContractListModule(query);
            if (list != null && list.Count > 0)
            {
                foreach (var item in list)
                {
                    if (item.CreateBy > 0)
                    {
                        item.CreateByName = UserReidsCache.GetUserLoginInfo(item.CreateBy)?.Account ?? "";
                    }
                }
            }
            return ApiResult.Success(data: list);
        }

        /// <summary>
        /// 新增修改联系人
        /// </summary>
        /// <returns></returns>
        public ApiResult SetContract()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var extModel = new RB_Contract_Extend()
            {
                Id = parms.GetInt("Id"),
                Name = parms.GetStringValue("Name"),
                Tel = parms.GetStringValue("Tel"),
                HeadIcon = parms.GetStringValue("HeadIcon"),
                BgImg = parms.GetStringValue("BgImg"),
                Position = parms.GetStringValue("Position"),
                Intro = parms.GetStringValue("Intro")
            };
            extModel.Status = Common.Enum.DateStateEnum.Normal;
            extModel.MallBaseId = RequestParm.MallBaseId;
            extModel.TenantId = RequestParm.TenantId;
            Int32.TryParse(RequestParm.uid, out int Uid);
            extModel.CreateBy = Uid;
            extModel.CreateDate = DateTime.Now;
            extModel.UpdateBy = Uid;
            extModel.UpdateDate = DateTime.Now;
            var flag = module.SetContractModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取角色实体
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        [AllowAnonymous]
        public ApiResult GetContract()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var extModel = module.GetContractModule(Id);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 删除联系人
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveContract()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var Status = parms.GetInt("Status", 0);
            var flag = module.RemoveContractModule(Id, Status);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        #endregion

        #region 投资采购管理

        /// <summary>
        /// 获取投资采购分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetInvestmentProcurementPage()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_InvestmentProcurement_Extend()
            {
                CompanyName = parms.GetStringValue("CompanyName"),
                Type=parms.GetInt("Type"),
            };
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = procurementModule.GetInvestmentProcurementPageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }

        

        /// <summary>
        /// 获取投资采购详情
        /// </summary>
        /// <returns></returns>
        public ApiResult GetInvestmentProcurement()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var extModel = procurementModule.GetInvestmentProcurementModule(Id);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 删除投资采购信息
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveInvestmentProcurement()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var Status = parms.GetInt("Status", 0);
            var flag = procurementModule.RemoveInvestmentProcurementModule(Id, Status);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 投资采购审核
        /// </summary>
        /// <returns></returns>
        public ApiResult AutitInvestmentProcurement()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            Int32.TryParse(RequestParm.uid, out int Uid);
            var extModel = new RB_InvestmentProcurement_Extend()
            {
                Id = parms.GetInt("Id"),
                AuditStatus=parms.GetInt("AuditStatus"),
                AuditTime = DateTime.Now,
                AuditBy = Uid,
                AuditContent = parms.GetStringValue("AuditContent")
            };
            var flag = procurementModule.AuditInvestmentProcurementModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }
        #endregion

        #region 公司信息管理

        /// <summary>
        /// 获取公司信息分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetCompanyPageList()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Company_Extend()
            {
                CompanyName = parms.GetStringValue("CompanyName")
            };
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = companyModule.GetCompanyPageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }


        /// <summary>
        /// 获取公司信息详情
        /// </summary>
        /// <returns></returns>
        public ApiResult GetCompany()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var CompanyId = parms.GetInt("CompanyId", 0);
            var extModel = companyModule.GetCompanyModule(CompanyId);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 删除公司信息
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveCompany()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var CompanyId = parms.GetInt("CompanyId", 0);
            var Status = parms.GetInt("Status", 0);
            var flag = companyModule.RemoveCompanyModule(CompanyId, Status);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }
        #endregion

        #region 商会活动管理

        /// <summary>
        /// 获取商会活动分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetCommerceActivityPage()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            JObject jObj = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Commerce_Activity_Extend()
            {
                ActivityName = jObj.GetStringValue("ActivityName")
            };
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = activityModule.GetCommerceActivityPageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query,isQuerySignup:true);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 新增修改商会活动
        /// </summary>
        /// <returns></returns>
        public ApiResult SetCommerceActivity()
        {
            JObject jObj = JObject.Parse(RequestParm.msg.ToString());
            var extModel = new RB_Commerce_Activity_Extend()
            {
                Id = jObj.GetInt("Id"),
                ActivityName = jObj.GetStringValue("ActivityName"),
                StartTime = jObj.GetDateTime("StartTime"),
                EndTime = jObj.GetDateTime("EndTime"),
                CoverImg = jObj.GetStringValue("CoverImg"),
                ActivityType = jObj.GetInt("ActivityType"),
                ActivityInfo = jObj.GetStringValue("ActivityInfo"),
                SignStartTime = jObj.GetDateTime("SignStartTime"),
                SignEndTime = jObj.GetDateTime("SignEndTime"),
                IsFree = jObj.GetInt("IsFree", 1),
                Price = jObj.GetInt("Price", 0),
                IsCancelConfirm = jObj.GetInt("IsCancelConfirm", 2)
            };
            try
            {
                extModel.CommerceDetailsList = Common.Plugin.JsonHelper.DeserializeObject<List<RB_Commerce_Details_Extend>>(jObj.GetStringValue("CommerceDetailsList"));
            }
            catch (Exception ex)
            {
                Common.Plugin.LogHelper.Write(ex, "SetCommerceActivity_CommerceDetailsList");
            }
            extModel.Status = Common.Enum.DateStateEnum.Normal;
            extModel.MallBaseId = RequestParm.MallBaseId;
            extModel.TenantId = RequestParm.TenantId;
            Int32.TryParse(RequestParm.uid, out int Uid);
            extModel.CreateBy = Uid;
            extModel.CreateDate = DateTime.Now;
            extModel.UpdateBy = Uid;
            extModel.UpdateDate = DateTime.Now;
            if (extModel.IsFree == 1) {
                extModel.Price = 0;
            }
            var flag = activityModule.SetCommerceActivityModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取商会活动详情
        /// </summary>
        /// <returns></returns>
        public ApiResult GetCommerceActivity()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var extModel = activityModule.GetCommerceActivityModule(Id);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 更新商户活动状态
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveCommerceActivity()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var Status = parms.GetInt("Status", 0);
            var flag = activityModule.RemoveCommerceActivityModule(Id, Status);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取商会活动类型分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetCommerceActivityTypePage()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            JObject jObj = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Commerce_ActivityType_Extend()
            {
                TypeName = jObj.GetStringValue("TypeName")
            };
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = activityModule.GetCommerceActivityTypePageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            list.ForEach(x=>x.LableNameList = string.IsNullOrWhiteSpace(x.LableName) ? new List<string>() : JsonConvert.DeserializeObject<List<string>>(x.LableName) );
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 获取商会活动类型列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetCommerceActivityTypeList()
        {
            JObject jObj = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Commerce_ActivityType_Extend()
            {
                TypeName = jObj.GetStringValue("TypeName")
            };
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = activityModule.GetCommerceActivityTypeListModule(query);
            list.ForEach(x => x.LableNameList = string.IsNullOrWhiteSpace(x.LableName) ? new List<string>() : JsonConvert.DeserializeObject<List<string>>(x.LableName));
            return ApiResult.Success(data: list);
        }

        /// <summary>
        /// 新增修改商会活动类型
        /// </summary>
        /// <returns></returns>
        public ApiResult SetCommerceActivityType()
        {
            RB_Commerce_ActivityType_Extend extModel = JsonConvert.DeserializeObject<RB_Commerce_ActivityType_Extend>(RequestParm.msg.ToString());
            //JObject jObj = JObject.Parse(RequestParm.msg.ToString());
            //var extModel = new RB_Commerce_ActivityType_Extend()
            //{
            //    Id = jObj.GetInt("Id"),
            //    TypeName = jObj.GetStringValue("TypeName"),
            //    CoverImage=jObj.GetStringValue("CoverImage")
            //};
            extModel.Status = Common.Enum.DateStateEnum.Normal;
            extModel.MallBaseId = RequestParm.MallBaseId;
            extModel.TenantId = RequestParm.TenantId;
            Int32.TryParse(RequestParm.uid, out int Uid);
            extModel.CreateBy = Uid;
            extModel.CreateDate = DateTime.Now;
            extModel.UpdateBy = Uid;
            extModel.UpdateDate = DateTime.Now;
            if (extModel.LableNameList != null && extModel.LableNameList.Any())
            {
                extModel.LableName = JsonConvert.SerializeObject(extModel.LableNameList);
            }
            else {
                extModel.LableName = "";
            }
            var flag = activityModule.SetCommerceActivityTypeModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取商会活动类型详情
        /// </summary>
        /// <returns></returns>
        public ApiResult GetCommerceActivityType()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var extModel = activityModule.GetCommerceActivityTypeModule(Id);
            extModel.LableNameList = string.IsNullOrWhiteSpace(extModel.LableName) ? new List<string>() : JsonConvert.DeserializeObject<List<string>>(extModel.LableName);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 更新商户活动类型状态
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveCommerceActivityType()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var Status = parms.GetInt("Status", 0);
            var flag = activityModule.RemoveCommerceActivityTypeModule(Id, Status);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }
        #endregion

        #region 商会活动报名管理

        /// <summary>
        /// 获取商会活动报名分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetCommerceConsultPage()
        {
            JObject jObj = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Commerce_Consult_Extend()
            {
                ActivityId = jObj.GetInt("ActivityId", 0),
                LinkMan = jObj.GetStringValue("LinkMan"),
                EnrollState = jObj.GetInt("EnrollState", 0)
            };
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = consultModule.GetCommerceConsultListModule(query);
            return ApiResult.Success(data: list);
        }

       

        /// <summary>
        /// 根据编号获取商会活动报名实体
        /// </summary>
        /// <returns></returns>
        public ApiResult GetCommerceConsult()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var extModel = consultModule.GetCommerceConsultModule(Id);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 更新商会活动报名状态
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveCommerceConsult()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var Status = parms.GetInt("Status", 0);
            var flag = consultModule.RemoveCommerceConsultModule(Id, Status);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 操作商会活动报名申请取消
        /// </summary>
        /// <returns></returns>
        public ApiResult SetCommerceConsultApplyCancel()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var ApplyForCancelStatus = parms.GetInt("ApplyForCancelStatus", 0);//申请取消审核状态  1同意  2拒绝
            var RejectRemark = parms.GetStringValue("RejectRemark");//拒绝备注
            if (Id <= 0) {
                return ApiResult.ParamIsNull("请传递");
            }
            if (ApplyForCancelStatus == 2) {
                if (string.IsNullOrEmpty(RejectRemark)) {
                    return ApiResult.ParamIsNull("请输入拒绝的原因");
                }
            }
            var flag = consultModule.SetCommerceConsultApplyCancel(Id, ApplyForCancelStatus, RejectRemark);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }
        #endregion

        #region 新闻信息管理

        /// <summary>
        /// 获取新闻信息分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetCommerceNewsPage()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Commerce_News_Extend()
            {
                Title = parms.GetStringValue("Title"),
                Type=parms.GetInt("Type"),
            };
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = commerceNewsModule.GetCommerceNewsPageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }


        /// <summary>
        /// 获取新闻信息详情
        /// </summary>
        /// <returns></returns>
        public ApiResult GetCommerceNews()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var extModel = commerceNewsModule.GetCommerceNewsModule(Id);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 删除新闻信息
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveCommerceNews()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var Status = parms.GetInt("Status", 0);
            var flag = commerceNewsModule.RemoveCommerceNewsModule(Id, Status);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 新增修改新闻
        /// </summary>
        /// <returns></returns>
        public ApiResult SetCommerceNews()
        {
            JObject jObj = JObject.Parse(RequestParm.msg.ToString());
            var extModel = new RB_Commerce_News_Extend()
            {
                Id = jObj.GetInt("Id"),
                CoverImg=jObj.GetStringValue("CoverImg"),
                Title= jObj.GetStringValue("Title"),
                Industry = jObj.GetStringValue("Industry"),
                PublishTime = jObj.GetDateTime("PublishTime"),
                NewsInfo = jObj.GetStringValue("NewsInfo"),
                Type=jObj.GetInt("Type"),
            };
            extModel.Status = Common.Enum.DateStateEnum.Normal;
            extModel.MallBaseId = RequestParm.MallBaseId;
            extModel.TenantId = RequestParm.TenantId;
            Int32.TryParse(RequestParm.uid, out int Uid);
            extModel.CreateBy = Uid;
            extModel.CreateDate = DateTime.Now;
            extModel.UpdateBy = Uid;
            extModel.UpdateDate = DateTime.Now;
            var flag = commerceNewsModule.SetCommerceNewsModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }
        #endregion

        #region 咨询管理
        /// <summary>
        /// 获取投资采购分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetCommerceAskPage()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Commerce_Ask_Extend()
            {
                CompanyName = parms.GetStringValue("CompanyName"),
            };
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = askModule.GetCommerceAskPageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 获取新闻信息详情
        /// </summary>
        /// <returns></returns>
        public ApiResult GetCommerceAskInfo()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var extModel = askModule.GetCommerceAskModule(Id);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 获取新闻信息详情
        /// </summary>
        /// <returns></returns>
        public ApiResult ReplyCommerceAsk()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            Int32.TryParse(RequestParm.uid, out int Uid);
            var model = new RB_Commerce_Ask_Extend()
            {
                Id = parms.GetInt("Id", 0),
                AskStatus = parms.GetInt("AskStatus"),
                ReplyTime =DateTime.Now,
                FatContent=parms.GetStringValue("FatContent"),
                ReplyId= Uid
            };
            var extModel = askModule.ReplyCommerceAskModule(model);
            return ApiResult.Success(data: extModel);
        }
        #endregion
    }
}
