﻿using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;

namespace Mall.Model.Entity.Education
{
    /// <summary>
    /// 活动期数明细实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "EduConnection")]
    public class RB_Activity_PeriodsDetail
    {
        /// <summary>
        /// 编号
        /// </summary>
        public int Id { get; set; }

        /// <summary>
        /// 关联用户
        /// </summary>
        public int UserId { get; set; }

        /// <summary>
        /// 活动id
        /// </summary>
        public int ActivityId { get; set; }

        /// <summary>
        /// 订单ID
        /// </summary>
        public int OrderId { get; set; }

        /// <summary>
        /// 提成金额
        /// </summary>
        public decimal CommissionMoney { get; set; }

        /// <summary>
        /// 期数id
        /// </summary>
        public int PeriodId { get; set; }

        /// <summary>
        /// 期号
        /// </summary>
        public string Periods { get; set; }

        /// <summary>
        /// 部门id
        /// </summary>
        public int Depart_Id { get; set; }

        /// <summary>
        /// 校区id
        /// </summary>
        public int School_Id { get; set; }

        /// <summary>
        /// 集团id
        /// </summary>
        public int Group_Id { get; set; }

        /// <summary>
        /// 备注
        /// </summary>
        public string Remark { get; set; }

        /// <summary>
        /// 电商报名用户Id
        /// </summary>
        public int DSUserId { get; set; }

        /// <summary>
        /// 电商报名用户名称
        /// </summary>
        public string DSUserName { get; set; }

        /// <summary>
        /// 活动名称
        /// </summary>
        public string ActivityName { get; set; }

        /// <summary>
        /// 提成类型  1人头   2比例
        /// </summary>
        public int CType { get; set; }

        /// <summary>
        /// 提成金额/比例
        /// </summary>
        public decimal CMoney { get; set; }

        /// <summary>
        /// 活动时间
        /// </summary>
        public DateTime ActivityTime { get; set; }
    }
}
