﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;
using Mall.Model.Extend.Product;
using System.Linq;

namespace Mall.Repository.Product
{
    /// <summary>
    /// 商品快速购买仓储层
    /// </summary>
    public class RB_Product_QuickBuyRepository : BaseRepository<RB_Product_QuickBuy>
    {

        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Product_QuickBuy_Extend> GetPageList(int pageIndex, int pageSize, out long rowCount, RB_Product_QuickBuy_Extend dmodel)
        {
            string where = $" 1=1 and qb.{nameof(RB_Product_QuickBuy_Extend.Status)}=0";
            if (dmodel.TenantId > 0) {
                where += $@" and qb.{nameof(RB_Product_QuickBuy_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0) {
                where += $@" and qb.{nameof(RB_Product_QuickBuy_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0) {
                where += $@" and qb.{nameof(RB_Product_QuickBuy_Extend.Id)}={dmodel.Id}";
            }
            if (dmodel.CategoryId > 0) {
                where += $@" and qb.{nameof(RB_Product_QuickBuy_Extend.CategoryId)}={dmodel.CategoryId}";
            }
            if (!string.IsNullOrEmpty(dmodel.CategoryName)) {
                where += $@" and c.{nameof(RB_Product_Category.Name)} like '%{dmodel.CategoryName}%'";
            }

            string sql = $@"select qb.*,c.Name as CategoryName,c.Icon from RB_Product_QuickBuy qb
inner join rb_product_category c on qb.CategoryId=c.Id
where {where} order by qb.Sort asc,Id desc";
            return GetPage<RB_Product_QuickBuy_Extend>(pageIndex, pageSize, out rowCount, sql).ToList();
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Product_QuickBuy_Extend> GetAllList(RB_Product_QuickBuy_Extend dmodel)
        {
            string where = $" 1=1 and qb.{nameof(RB_Product_QuickBuy_Extend.Status)}=0";
            if (dmodel.TenantId > 0)
            {
                where += $@" and qb.{nameof(RB_Product_QuickBuy_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and qb.{nameof(RB_Product_QuickBuy_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0)
            {
                where += $@" and qb.{nameof(RB_Product_QuickBuy_Extend.Id)}={dmodel.Id}";
            }
            if (dmodel.CategoryId > 0)
            {
                where += $@" and qb.{nameof(RB_Product_QuickBuy_Extend.CategoryId)}={dmodel.CategoryId}";
            }
            if (!string.IsNullOrEmpty(dmodel.CategoryName))
            {
                where += $@" and c.{nameof(RB_Product_Category.Name)} like '%{dmodel.CategoryName}%'";
            }

            string sql = $@"select qb.*,c.Name as CategoryName,c.Icon from RB_Product_QuickBuy qb
inner join rb_product_category c on qb.CategoryId=c.Id
where {where} order by qb.Sort asc,Id desc";
            return Get<RB_Product_QuickBuy_Extend>(sql).ToList();
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Product_QuickBuy_Extend> GetList(RB_Product_QuickBuy_Extend dmodel)
        {
            string where = $" 1=1 and {nameof(RB_Product_QuickBuy_Extend.Status)}=0";
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Product_QuickBuy_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Product_QuickBuy_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0)
            {
                where += $@" and {nameof(RB_Product_QuickBuy_Extend.Id)}={dmodel.Id}";
            }
            if (dmodel.CategoryId > 0)
            {
                where += $@" and {nameof(RB_Product_QuickBuy_Extend.CategoryId)}={dmodel.CategoryId}";
            }
            if (!string.IsNullOrEmpty(dmodel.CategoryName))
            {
                where += $@" and {nameof(RB_Product_QuickBuy_Extend.CategoryName)} like '%{dmodel.CategoryName}%'";
            }

            string sql = $@"select * from RB_Product_QuickBuy where {where} order by Id desc";
            return Get<RB_Product_QuickBuy_Extend>(sql).ToList();
        }
    }
}
