﻿
using Mall.Common;
using Mall.Model.Extend.Product;
using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;

namespace Mall.DataHelper
{
    /// <summary>
    /// 商品导入
    /// </summary>
    public class GoodsBetchDataHelper
    {
        /// <summary>
        /// 导入模板
        /// </summary>
        /// <param name="fileName"></param>
        /// <returns></returns>
        public static List<RB_Goods_Extend> ImportClaimData(string fileName)
        {
            List<RB_Goods_Extend> list = new List<RB_Goods_Extend>();
            var dt = new DataTable();
            if (fileName.Contains(".csv"))
            {
                dt = new CSVHelper().GetStream(fileName);
            }
            else {
                dt = Mall.Common.Plugin.NPOIHelper.ImportExceltoDt(fileName, 0, 0, true);
            }
            if (dt != null && dt.Rows.Count > 0)
            {
                foreach (DataRow dr in dt.Rows)
                {
                    list.Add(DataRowToModel(dr));
                }
            }
            return list;
        }
        /// <summary>
        /// DataRow转实体
        /// </summary>
        /// <param name="dr"></param>
        /// <returns></returns>
        public static RB_Goods_Extend DataRowToModel(DataRow dr)
        {
            RB_Goods_Extend model = new RB_Goods_Extend();
            if (dr != null)
            {
                if (dr.Table.Columns.Contains("商品名称") && !string.IsNullOrEmpty(dr["商品名称"].ToString().Trim()))
                {
                    model.Name = dr["商品名称"].ToString();
                }
                if (dr.Table.Columns.Contains("原价") && !string.IsNullOrEmpty(dr["原价"].ToString().Trim()))
                {
                    model.OriginalPrice = Convert.ToDecimal(dr["原价"].ToString());
                }
                if (dr.Table.Columns.Contains("成本价") && !string.IsNullOrEmpty(dr["成本价"].ToString().Trim()))
                {
                    model.CostPrice = Convert.ToDecimal(dr["成本价"].ToString());
                }
                if (dr.Table.Columns.Contains("商品详情") && !string.IsNullOrEmpty(dr["商品详情"].ToString().Trim()))
                {
                    model.GoodsDetails = dr["商品详情"].ToString();
                }
                if (dr.Table.Columns.Contains("商品缩略图") && !string.IsNullOrEmpty(dr["商品缩略图"].ToString().Trim()))
                {
                    model.CoverImage = dr["商品缩略图"].ToString();
                }
                if (dr.Table.Columns.Contains("商品轮播图") && !string.IsNullOrEmpty(dr["商品轮播图"].ToString().Trim()))
                {
                    model.CarouselImage = dr["商品轮播图"].ToString();
                }
                if (dr.Table.Columns.Contains("商品视频") && !string.IsNullOrEmpty(dr["商品视频"].ToString().Trim()))
                {
                    model.VideoAddress = dr["商品视频"].ToString();
                }
                if (dr.Table.Columns.Contains("单位") && !string.IsNullOrEmpty(dr["单位"].ToString().Trim()))
                {
                    model.Unit = dr["单位"].ToString();
                }
                if (dr.Table.Columns.Contains("售价") && !string.IsNullOrEmpty(dr["售价"].ToString().Trim()))
                {
                    model.SellingPrice = Convert.ToDecimal(dr["售价"].ToString());
                }
                if (dr.Table.Columns.Contains("是否使用规格") && !string.IsNullOrEmpty(dr["是否使用规格"].ToString().Trim()))
                {
                    model.IsCustomSpecification = Convert.ToInt32(dr["是否使用规格"].ToString());
                }
                if (dr.Table.Columns.Contains("规格组") && !string.IsNullOrEmpty(dr["规格组"].ToString().Trim()))
                {
                    model.SpecificationImport = dr["规格组"].ToString();
                }
                if (dr.Table.Columns.Contains("商品库存") && !string.IsNullOrEmpty(dr["商品库存"].ToString().Trim()))
                {
                    model.InventoryNum = Convert.ToInt32(dr["商品库存"].ToString());
                }
                if (dr.Table.Columns.Contains("虚拟销量") && !string.IsNullOrEmpty(dr["虚拟销量"].ToString().Trim()))
                {
                    model.SalesNum = Convert.ToInt32(dr["虚拟销量"].ToString());
                }
                if (dr.Table.Columns.Contains("购物数量限制") && !string.IsNullOrEmpty(dr["购物数量限制"].ToString().Trim()))
                {
                    model.LimitBuyGoodsNum = Convert.ToInt32(dr["购物数量限制"].ToString());
                }
                if (dr.Table.Columns.Contains("单品满件包邮") && !string.IsNullOrEmpty(dr["单品满件包邮"].ToString().Trim()))
                {
                    model.FullNumPinkage = Convert.ToInt32(dr["单品满件包邮"].ToString());
                }
                if (dr.Table.Columns.Contains("单品满额包邮") && !string.IsNullOrEmpty(dr["单品满额包邮"].ToString().Trim()))
                {
                    model.FullMoneyPinkage = Convert.ToDecimal(dr["单品满额包邮"].ToString());
                }
                if (dr.Table.Columns.Contains("赠送积分") && !string.IsNullOrEmpty(dr["赠送积分"].ToString().Trim()))
                {
                    model.IntegralPresent = Convert.ToInt32(dr["赠送积分"].ToString());
                }
                if (dr.Table.Columns.Contains("赠送积分类型") && !string.IsNullOrEmpty(dr["赠送积分类型"].ToString().Trim()))
                {
                    model.IntegralPresentType = Convert.ToInt32(dr["赠送积分类型"].ToString());
                }
                if (dr.Table.Columns.Contains("可抵扣积分") && !string.IsNullOrEmpty(dr["可抵扣积分"].ToString().Trim()))
                {
                    model.PointsDeduction = Convert.ToDecimal(dr["可抵扣积分"].ToString());
                }
                if (dr.Table.Columns.Contains("可抵扣积分类型") && !string.IsNullOrEmpty(dr["可抵扣积分类型"].ToString().Trim()))
                {
                    model.PointsDeductionType = Convert.ToInt32(dr["可抵扣积分类型"].ToString());
                }
                if (dr.Table.Columns.Contains("允许多件累计折扣") && !string.IsNullOrEmpty(dr["允许多件累计折扣"].ToString().Trim()))
                {
                    model.IsMultipleDeduction = Convert.ToInt32(dr["允许多件累计折扣"].ToString());
                }
                if (dr.Table.Columns.Contains("自定义分享图片") && !string.IsNullOrEmpty(dr["自定义分享图片"].ToString().Trim()))
                {
                    model.CustomShareImage = dr["自定义分享图片"].ToString();
                }
                if (dr.Table.Columns.Contains("自定义分享标题") && !string.IsNullOrEmpty(dr["自定义分享标题"].ToString().Trim()))
                {
                    model.CustomShareTitles = dr["自定义分享标题"].ToString();
                }
                if (dr.Table.Columns.Contains("排序") && !string.IsNullOrEmpty(dr["排序"].ToString().Trim()))
                {
                    model.Sort = Convert.ToInt32(dr["排序"].ToString());
                }
                if (dr.Table.Columns.Contains("限购订单") && !string.IsNullOrEmpty(dr["限购订单"].ToString().Trim()))
                {
                    model.LimitBuyOrderNum = Convert.ToInt32(dr["限购订单"].ToString());
                }
                if (dr.Table.Columns.Contains("是否单独区域购买") && !string.IsNullOrEmpty(dr["是否单独区域购买"].ToString().Trim()))
                {
                    model.IsAreaBuy = Convert.ToInt32(dr["是否单独区域购买"].ToString());
                }
                if (dr.Table.Columns.Contains("区域限购详情") && !string.IsNullOrEmpty(dr["区域限购详情"].ToString().Trim()))
                {
                    model.AreaImport = dr["区域限购详情"].ToString();
                }
                if (dr.Table.Columns.Contains("规格详情") && !string.IsNullOrEmpty(dr["规格详情"].ToString().Trim()))
                {
                    model.SpecificationPriceImport = dr["规格详情"].ToString();
                }
                if (dr.Table.Columns.Contains("是否快速购买") && !string.IsNullOrEmpty(dr["是否快速购买"].ToString().Trim()))
                {
                    model.IsQuickBuy = Convert.ToInt32(dr["是否快速购买"].ToString());
                }
                if (dr.Table.Columns.Contains("是否热销") && !string.IsNullOrEmpty(dr["是否热销"].ToString().Trim()))
                {
                    model.IsSellWell = Convert.ToInt32(dr["是否热销"].ToString());
                }
                if (dr.Table.Columns.Contains("是否面议") && !string.IsNullOrEmpty(dr["是否面议"].ToString().Trim()))
                {
                    model.IsGoodsNegotiable = Convert.ToInt32(dr["是否面议"].ToString());
                }

            }
            return model;
        }
    }
}