﻿using VT.FW.DB;
using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Extend.Product;

namespace Mall.Model.Query
{

    /// <summary>
    /// 订单统计
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class OrderStatistics_Query
    {
        public string Ids { get; set; }
        public int Id { get; set; }
        public int OrderId { get; set; }

        /// <summary>
        /// 订单商品已付成本（商品成本+运费成本）
        /// </summary>
        public decimal PaidCostMoney { get; set; }
        public int TenantId { get; set; }

        public int MallBaseId { get; set; }

        /// <summary>
        /// 订单号
        /// </summary>
        public string OrderNo { get; set; }

        /// <summary>
        /// 商品名称
        /// </summary>
        public string GoodsName { get; set; }

        /// <summary>
        /// 付款时间
        /// </summary>
        public DateTime PaymentTime { get; set; }

        /// <summary>
        /// 下单用户id
        /// </summary>
        public int UserId { get; set; }

        /// <summary>
        /// 商品id
        /// </summary>
        public int GoodsID { get; set; }

        /// <summary>
        /// 规格
        /// </summary>
        public string Specification { get; set; }

        /// <summary>
        /// 单价
        /// </summary>
        public decimal Unit_Price { get; set; }

        /// <summary>
        /// 数量
        /// </summary>
        public int Number { get; set; }

        /// <summary>
        /// 返佣人员id
        /// </summary>
        public int OneUserId { get; set; }
        /// <summary>
        /// 返佣人员名称
        /// </summary>
        public string OneUserName { get; set; }

        /// <summary>
        /// 返佣人员id
        /// </summary>
        public int TwoUserId { get; set; }
        /// <summary>
        /// 返佣人员名称
        /// </summary>
        public string TwoUserName { get; set; }


        /// <summary>
        /// 供应商名称
        /// </summary>
        public string SupplierName { get; set; }



        /// <summary>
        /// 供应商名称
        /// </summary>
        public int SupplierId { get; set; }


        /// <summary>
        /// 特一级返佣
        /// </summary>
        public decimal SpecialCommission { get; set; }

        /// <summary>
        /// 总代理返佣
        /// </summary>
        public decimal GeneralAgentCommission { get; set; }


        /// <summary>
        /// 分公司
        /// </summary>
        public decimal BranchCommission { get; set; }

        /// <summary>
        /// 分公司
        /// </summary>
        public string BranchName { get; set; }

        /// <summary>
        /// 特一级返佣
        /// </summary>
        public string SpecialName { get; set; }

        /// <summary>
        /// 总代理返佣
        /// </summary>
        public string GeneralAgentName { get; set; }

        /// <summary>
        /// 粉象总返佣
        /// </summary>
        public decimal FXCommission { get; set; }

        /// <summary>
        /// 结算款
        /// </summary>
        public decimal Final_Price { get; set; }

        /// <summary>
        /// 运费
        /// </summary>
        public string FreightMoney { get; set; }


        /// <summary>
        /// 未收
        /// </summary>
        public decimal NoFinal_Price { get; set; }



        /// <summary>
        /// 结算款
        /// </summary>
        public decimal Income { get; set; }



        /// <summary>
        /// 已收
        /// </summary>
        public decimal AllPrice { get; set; }


        /// <summary>
        /// 采购成本
        /// </summary>
        public decimal CostMoney { get; set; }

        /// <summary>
        /// 包装费摊销
        /// </summary>
        public decimal PackingMoney { get; set; }
        /// <summary>
        /// 商品运费摊销
        /// </summary>
        public decimal CostFreight { get; set; }

        /// <summary>
        /// 商品运费成本
        /// </summary>
        public decimal GoodsFreight { get; set; }


        /// <summary>
        /// 一级返佣
        /// </summary>
        public decimal OneCommission { get; set; }

        /// <summary>
        /// 二级返佣
        /// </summary>
        public decimal TwoCommission { get; set; }


        /// <summary>
        /// 其他
        /// </summary>
        public decimal OtherPrice { get; set; }


        /// <summary>
        /// 营业（合计）
        /// </summary>
        public decimal ALLCommission { get; set; }

        /// <summary>
        /// 已付
        /// </summary>
        public decimal Paid { get; set; }
        /// <summary>
        /// 应付
        /// </summary>
        public decimal NoPaid { get; set; }

        /// <summary>
        /// 毛利
        /// </summary>
        public decimal GrossProfit { get; set; }


        /// <summary>
        /// 毛利率
        /// </summary>
        public decimal GrossProfitRate { get; set; }


        /// <summary>
        /// 开始时间
        /// </summary>
        public string StartDate { get; set; }

        /// <summary>
        /// 结束时间
        /// </summary>
        public string EndDate { get; set; }

        /// <summary>
        /// 0-普通，1-粉象
        /// </summary>
        public int IsFxCommission { get; set; }
        /// <summary>
        /// 订单返佣列表
        /// </summary>
        public List<RB_Goods_OrderCommission_Extend> OrderCommissionList { get; set; }

        /// <summary>
        /// 主要针对粉象查粉象返佣信息
        /// </summary>
        public int IsSelectOrderCommission { get; set; }

        /// <summary>
        /// 已提现返佣金额
        /// </summary>
        public decimal RemitFXCommission { get; set; }


        /// <summary>
        /// 主播应付佣金
        /// </summary>
        public decimal LiveCommission { get; set; }


        /// <summary>
        /// 主播已付佣金
        /// </summary>
        public decimal PaidLiveCommission { get; set; }

        /// <summary>
        /// 主播佣金生成的财务单据   逗号分隔
        /// </summary>
        public string LiveFinanceIds { get; set; }

        /// <summary>
        /// 主播数量
        /// </summary>
        public int LivePeopleNum { get; set; }


        /// <summary>
        /// 其他应收金额
        /// </summary>
        public decimal YSMoney { get; set; }
        /// <summary>
        /// 其他实收金额
        /// </summary>
        public decimal RealMoney { get; set; }
        /// <summary>
        /// 其他应付金额
        /// </summary>
        public decimal YFMoney { get; set; }
        /// <summary>
        /// 其他实付金额
        /// </summary>
        public decimal PayMoney { get; set; }
        /// <summary>
        /// 订单优惠金额
        /// </summary>
        public decimal CouponMoney { get; set; }

        /// <summary>
        /// 实际退款金额
        /// </summary>
        public decimal RefundActual { get; set; }

        /// <summary>
        /// 公司毛利返利
        /// </summary>
        public decimal CompanyProfitRate { get; set; }

        /// <summary>
        /// 订单所属公司
        /// </summary>
        public int CompanyId { get; set; }

        /// <summary>
        /// 订单所属公司
        /// </summary>

        public string CompanyName { get; set; }

        /// <summary>
        /// 订单状态
        /// </summary>
        public int OrderStatus { get; set; }

        /// <summary>
        /// 订单手续费
        /// </summary>
        public decimal ServiceCharge { get; set; }

        /// <summary>
        /// 订单手续费
        /// </summary>
        public decimal ReturnServiceCharge { get; set; }
        /// <summary>
        /// 保险收入
        /// </summary>
        public decimal InsuranceMoney { get; set; }



        /// <summary>
        /// 保险成本
        /// </summary>
        public decimal InsuranceCostMoney { get; set; }

        /// <summary>
        /// 出行类型
        /// </summary>
        public int CarType { get; set; }

        /// <summary>
        /// 订单类型0-正常订单，1-司导订单
        /// </summary>

        public int OrderClassify { get; set; }


        /// <summary>
        /// 订单来源（平台）  枚举
        /// </summary>        
        public Common.Enum.User.UserSourceEnum? OrderSource
        {
            get;
            set;
        }



        /// <summary>
        /// 储值卡抵扣金额
        /// </summary>
        public decimal TotalDepositMoney { get; set; }
    }
}
