﻿using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using System;
using System.Collections.Generic;
using System.Text;
using System.Linq;

namespace Mall.Repository.User
{
    /// <summary>
    /// 拼团配置仓储层对象
    /// </summary>
    public class RB_GroupBuyConfigRepository : BaseRepository<RB_GroupBuyConfig>
    {
        /// <summary>
        /// 获取拼团配置实体
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public RB_GroupBuyConfig_Extend GetGroupBuyConfigRepository(RB_GroupBuyConfig_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT * 
FROM  rb_groupbuyconfig
WHERE 1=1 
");
            if (query != null)
            {
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_GroupBuyConfig_Extend.MallBaseId), query.MallBaseId);
                }
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_GroupBuyConfig_Extend.TenantId), query.TenantId);
                }
                if (query.GroupByConfigId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_GroupBuyConfig_Extend.GroupByConfigId), query.GroupByConfigId);
                }
            }
            var extModel= Get<RB_GroupBuyConfig_Extend>(builder.ToString()).FirstOrDefault();
            if (extModel != null)
            {
                extModel.Payment_TypeList = new List<string>();
                if (!string.IsNullOrWhiteSpace(extModel.Payment_Type))
                {
                    extModel.Payment_TypeList = Common.Plugin.JsonHelper.DeserializeObject<List<string>>(extModel.Payment_Type);
                }
                extModel.Send_TypeList = new List<string>();
                if (!string.IsNullOrEmpty(extModel.Send_Type))
                {
                    extModel.Send_TypeList = Common.Plugin.JsonHelper.DeserializeObject<List<string>>(extModel.Send_Type);
                }
                extModel.BannerList = new List<GroupBuyBannerItem>();
                if (!string.IsNullOrWhiteSpace(extModel.BannerJson))
                {
                    extModel.BannerList = Common.Plugin.JsonHelper.DeserializeObject<List<GroupBuyBannerItem>>(extModel.BannerJson);
                }
                extModel.MagicDataList = new List<GroupBuyMagicItem>();
                if (!string.IsNullOrWhiteSpace(extModel.MagicJson))
                {
                    extModel.MagicDataList = Common.Plugin.JsonHelper.DeserializeObject<List<GroupBuyMagicItem>>(extModel.MagicJson);
                }
            }
            return extModel;
        }
    }
}
