﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Mall.Common.Pay.WeChatPat.Model
{

    /// <summary>
    /// 
    /// </summary>
    public class HttpParam
    {
        /// <summary>
        /// GET/POST
        /// </summary>
        public string Method { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public string Url { get; set; }
        /// <summary>
        /// 参数类型。可选：Json、Form。默认Json。传入Form则会将new { Key1 = Value1, Key2 = Value2}转换成"key1=value1＆key2=value2"形式。
        /// </summary>
        public HttpParamType ParamType { get; set; }
        /// <summary>
        /// Post参数。
        /// <para>可以传入Json对像：new { Key1 = Value1, Key2 = Value2}</para>
        /// <para>可以传入Json字符串：{"Key1":"Value1","Key2":"Value2"}</para>
        /// <para>可以传入key/value字符串："key1=value1＆key2=value2"</para>
        /// <para>可以传入xml字符串等等</para>
        /// </summary>
        public object PostParam { get; set; }
        /// <summary>
        /// Get参数
        /// <para>可以传入Json对像：new { Key1 = Value1, Key2 = Value2}</para>
        /// <para>可以传入Json字符串：{"Key1":"Value1","Key2":"Value2"}</para>
        /// </summary>
        public object GetParam { get; set; }

        private int _timeOut = 10;
        /// <summary>
        /// 请求超时时间。单位：秒。默认值5秒。
        /// </summary>
        public int TimeOut
        {
            get { return _timeOut; }
            set { _timeOut = value; }
        }
        private Encoding _encoding = Encoding.UTF8;
        /// <summary>
        /// 
        /// </summary>
        public Encoding Encoding
        {
            get { return _encoding; }
            set { _encoding = value; }
        }
        /// <summary>
        /// 
        /// </summary>
        public System.Net.CookieContainer CookieContainer { get; set; }
        /// <summary>
        /// 
        /// </summary>
        public string Referer { get; set; }
        /// <summary>
        /// 
        /// </summary>
        public string CertPath { get; set; }
        /// <summary>
        /// 
        /// </summary>
        public string CertPwd { get; set; }
        private string _contentType = "application/x-www-form-urlencoded";
        /// <summary>
        /// 
        /// </summary>
        public string ContentType
        {
            get { return _contentType; }
            set { _contentType = value; }
        }
        private string _userAgent = "Mozilla/5.0 (Windows NT 6.2; WOW64) AppleWebKit/537.1 (KHTML, like Gecko) Maxthon/4.1.2.4000 Chrome/26.0.1410.43 Safari/537.1";
        /// <summary>
        /// 
        /// </summary>
        public string UserAgent
        {
            get { return _userAgent; }
            set { _userAgent = value; }
        }
        /// <summary>
        /// 
        /// </summary>
       // public System.Web.HttpPostedFileBase PostedFile { get; set; }
    }

    /// <summary>
    /// Http请求参数类型枚举
    /// </summary>
    public enum HttpParamType
    {
        /// <summary>
        /// json数据。默认值。
        /// </summary>
        Json,
        /// <summary>
        /// 形如：key=value＆key=value＆key=value
        /// </summary>
        Form
    }
}
