﻿using VT.FW.DB;
using Mall.Common.Enum.User;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.Assess
{
    /// <summary>
    /// 估价品牌实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
	public class RB_Assess_Brand
	{
		/// <summary>
		/// Id
		/// </summary>
		public int Id { get; set; }

		/// <summary>
		/// 分类ID
		/// </summary>
		public int CategoryId { get; set; }

		/// <summary>
		/// 品牌名称
		/// </summary>
		public string Name { get; set; }

		/// <summary>
		/// 品牌图标
		/// </summary>
		public string Logo { get; set; }

		/// <summary>
		/// 用于排序
		/// </summary>
		public string PinYin { get; set; }

		/// <summary>
		/// 是否热门   1是
		/// </summary>
		public int IsHot { get; set; }

		/// <summary>
		/// 三组图 （json格式）
		/// </summary>
		public string BrandImg { get; set; }

		/// <summary>
		/// Status
		/// </summary>
		public int Status { get; set; }

		/// <summary>
		/// 商户号
		/// </summary>
		public int TenantId { get; set; }

		/// <summary>
		/// 小程序id
		/// </summary>
		public int MallBaseId { get; set; }

		/// <summary>
		/// 创建人
		/// </summary>
		public int CreateBy { get; set; }

		/// <summary>
		/// 创建时间
		/// </summary>
		public DateTime CreateDate { get; set; }

		/// <summary>
		/// 修改人
		/// </summary>
		public int UpdateBy { get; set; }

		/// <summary>
		/// 修改时间
		/// </summary>
		public DateTime UpdateDate { get; set; }

		/// <summary>
		/// 更多描述
		/// </summary>
		public string MoreDesc { get; set; }

		/// <summary>
		/// 备注描述
		/// </summary>
		public string RemarkDesc { get; set; }

	}
}
