﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Common.Enum.Education;
using VT.FW.DB;

namespace Mall.Model.Entity.Coffee
{
    /// <summary>
    /// 教育商品订单明细实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "EduConnection")]
	public class RB_Goods_OrderDetail
	{
		/// <summary>
		/// 明细ID
		/// </summary>
		public int Id { get; set; }

		/// <summary>
		/// OrderId
		/// </summary>
		public int OrderId { get; set; }

		/// <summary>
		/// 对应电商订单ID
		/// </summary>
		public int MallOrderId { get; set; }

		/// <summary>
		/// 对应电商订单明细ID
		/// </summary>
		public int MallOrderDetailId { get; set; }

		/// <summary>
		/// 单价
		/// </summary>
		public decimal Unit_Price { get; set; }

		/// <summary>
		/// 数量
		/// </summary>
		public int Number { get; set; }

		/// <summary>
		/// 应收金额
		/// </summary>
		public decimal PreferPrice { get; set; }

		/// <summary>
		/// 实收金额
		/// </summary>
		public decimal Income { get; set; }

		/// <summary>
		/// 手续费
		/// </summary>
		public decimal Fee { get; set; }

		/// <summary>
		/// 运费
		/// </summary>
		public decimal FreightMoney { get; set; }

		/// <summary>
		/// 教育商品id
		/// </summary>
		public int GoodsId { get; set; }

		/// <summary>
		/// 对应电商商品ID
		/// </summary>
		public int MallGoodsId { get; set; }

		/// <summary>
		/// 商品名称
		/// </summary>
		public string GoodsName { get; set; }

		/// <summary>
		/// 封面图
		/// </summary>
		public string CoverImage { get; set; }

		/// <summary>
		/// 总成本价格
		/// </summary>
		public decimal CostMoney { get; set; }

		/// <summary>
		/// 删除状态
		/// </summary>
		public int Status { get; set; }

		/// <summary>
		/// 集团ID
		/// </summary>
		public int Group_Id { get; set; }

		/// <summary>
		/// 小程序id
		/// </summary>
		public int MallBaseId { get; set; }

		/// <summary>
		/// CreateDate
		/// </summary>
		public DateTime CreateDate { get; set; }

		/// <summary>
		/// UpdateDate
		/// </summary>
		public DateTime UpdateDate { get; set; }

		/// <summary>
		/// 对应的物料档案ID
		/// </summary>
		public int MaterialId { get; set; }

		/// <summary>
		/// 商品运费成本
		/// </summary>
		public decimal FreightCostMoney { get; set; }
	}
}
