﻿using VT.FW.DB;
using Mall.Common.Enum.User;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.Product
{
    /// <summary>
    /// 不开发票商品提现信息表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Invoice_Online_Trade
    {

        /// <summary>
        /// Id
        /// </summary>        
        public int Id
        {
            get;
            set;
        }
        /// <summary>
        /// 用户id
        /// </summary>        
        public int User_Id
        {
            get;
            set;
        }


        /// <summary>
        /// 订单号
        /// </summary>        
        public string Out_Trade_No
        {
            get;
            set;
        }
        /// <summary>
        /// 微信支付订单号
        /// </summary>        
        public string Transaction_Id
        {
            get;
            set;
        }
        /// <summary>
        /// 支付类型 枚举  1微信  2支付宝   3银行卡 
        /// </summary>        
        public Common.Enum.Goods.OrderPayTypeEnum? PayWay
        {
            get;
            set;
        }
        /// <summary>
        /// 支付调用的是哪种api
        /// </summary>        
        public string PayType
        {
            get;
            set;
        }
        /// <summary>
        /// 交易金额
        /// </summary>        
        public decimal? Money
        {
            get;
            set;
        }
        /// <summary>
        /// 备注附加信息
        /// </summary>        
        public string Remarks
        {
            get;
            set;
        }
        /// <summary>
        /// 0-成功  其他-失败
        /// </summary>        
        public int? Pay_Result
        {
            get;
            set;
        }
        /// <summary>
        /// 交易日期
        /// </summary>        
        public DateTime? Pay_Date
        {
            get;
            set;
        }

        /// <summary>
        /// 绑定财务单据id
        /// </summary>        
        public int? FinanceId
        {
            get;
            set;
        }


        /// <summary>
        /// 创建人
        /// </summary>        
        public int CreateBy
        {
            get;
            set;
        }
        /// <summary>
        /// 商户号
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }
        /// <summary>
        /// 小程序id
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }
        /// <summary>
        /// CreateDate
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }
    }
}
