﻿using Mall.Common.Enum;
using Mall.Model.Entity.TradePavilion;
using Mall.Model.Extend.TradePavilion;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VT.FW.DB.Dapper;

namespace Mall.Repository.TradePavilion
{
    /// <summary>
    /// 自定义表单仓储层
    /// </summary>
    public class RB_Custom_FormRepository : BaseRepository<RB_Custom_Form>
    {
        /// <summary>
        /// 获取自定义表单分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Custom_Form_Extend> GetCustomFormPageRepository(int pageIndex, int pageSize, out long rowsCount, RB_Custom_Form_Extend query)
        {
            var parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT A.*
FROM RB_Custom_Form AS A
WHERE 1=1
");
            builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Custom_Form_Extend.Status), (int)DateStateEnum.Normal);
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Custom_Form_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Custom_Form_Extend.MallBaseId), query.MallBaseId);
                }
                if (!string.IsNullOrEmpty(query.FormName))
                {
                    builder.AppendFormat(" AND A.{0} LIKE @FormName ", nameof(RB_Custom_Form_Extend.FormName));
                    parameters.Add("FormName", "%" + query.FormName.Trim() + "%");
                }
                if (query.Id > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Custom_Form_Extend.Id), query.Id);
                }
            }
            return GetPage<RB_Custom_Form_Extend>(pageIndex, pageSize, out rowsCount, builder.ToString(), parameters).ToList();
        }

        /// <summary>
        /// 获取自定义表单列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Custom_Form_Extend> GetCustomFormListRepository(RB_Custom_Form_Extend query)
        {
            var parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT A.*
FROM RB_Custom_Form AS A
WHERE 1=1
");
            builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Custom_Form_Extend.Status), (int)DateStateEnum.Normal);
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Custom_Form_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Custom_Form_Extend.MallBaseId), query.MallBaseId);
                }
                if (!string.IsNullOrEmpty(query.FormName))
                {
                    builder.AppendFormat(" AND A.{0} LIKE @FormName ", nameof(RB_Custom_Form_Extend.FormName));
                    parameters.Add("FormName", "%" + query.FormName.Trim() + "%");
                }
                if (query.Id > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Custom_Form_Extend.Id), query.Id);
                }
                if (query.FormType > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Custom_Form_Extend.FormType), (int)query.FormType);
                }
            }
            return Get<RB_Custom_Form_Extend>(builder.ToString(), parameters).ToList();
        }



        /// <summary>
        /// 获取自定义表单列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Custom_Form_Extend> GetCustomFormByIdsListRepository(RB_Custom_Form_Extend query,string FormIds)
        {
            var parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT A.*
FROM RB_Custom_Form AS A
WHERE 1=1
");
           // builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Custom_Form_Extend.Status), (int)DateStateEnum.Normal);
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Custom_Form_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Custom_Form_Extend.MallBaseId), query.MallBaseId);
                }
                if (!string.IsNullOrEmpty(query.FormName))
                {
                    builder.AppendFormat(" AND A.{0} LIKE @FormName ", nameof(RB_Custom_Form_Extend.FormName));
                    parameters.Add("FormName", "%" + query.FormName.Trim() + "%");
                }
                if (query.Id > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Custom_Form_Extend.Id), query.Id);
                }
                if (!string.IsNullOrWhiteSpace(FormIds))
                {
                    builder.AppendFormat(" AND A.{0} in ({1}) ", nameof(RB_Custom_Form_Extend.Id), FormIds);
                }
                if (query.FormType > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Custom_Form_Extend.FormType), (int)query.FormType);
                }
            }
            return Get<RB_Custom_Form_Extend>(builder.ToString(), parameters).ToList();
        }
    }
}
