﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Model.Entity.Point;
using Mall.Model.Extend.Point;

namespace Mall.Repository.Point
{
    public class RB_Point_TeacherCourseRepository : BaseRepository<RB_Point_TeacherCourse>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_Point_TeacherCourse); } }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_Point_TeacherCourse_Extend> GetTeacherCourseList(RB_Point_TeacherCourse_Extend where)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append($@"SELECT tc.*,et.`Name` as TeacherName,et.TeacherLogo,cc.CourseClassType,
cc.StudentNumType,cc.IsPublic,cc.IsFree
from RB_Point_TeacherCourse as tc  
LEFT JOIN rb_point_courseclass as cc on tc.CourseClassId=cc.ID
LEFT JOIN rb_education_teacher as et on tc.TeacherId=et.ID
 where tc.state=0 and cc.state=0 and et.`Status`=0");
            if (where != null)
            {
                if (where.TenantId > 0)
                {
                    sb.AppendFormat(" and tc.TenantId={0}", where.TenantId);
                }
                if (where.MallBaseId > 0)
                {
                    sb.AppendFormat(" and tc.MallBaseId={0}", where.MallBaseId);
                }
                if (where.MallBaseId > 0)
                {
                    sb.AppendFormat(" and tc.MallBaseId={0}", where.MallBaseId);
                }
                if (where.CourseClassId > 0)
                {
                    sb.AppendFormat(" and tc.CourseClassId={0}", where.CourseClassId);
                }
                if (where.TeacherId > 0)
                {
                    sb.AppendFormat(" and tc.TeacherId={0}", where.TeacherId);
                }
                if (!string.IsNullOrEmpty(where.SelectStartTime))
                {
                    sb.AppendFormat(" AND DATE_FORMAT(tc.{0},'%y-%m-%d')>=DATE_FORMAT('{1}','%y-%m-%d') ", nameof(RB_Point_TeacherCourse_Extend.StudyDate), where.SelectStartTime);
                }
                if (!string.IsNullOrEmpty(where.SelectEndTime))
                {
                    sb.AppendFormat(" AND DATE_FORMAT(tc.{0},'%y-%m-%d')<=DATE_FORMAT('{1}','%y-%m-%d') ", nameof(RB_Point_TeacherCourse_Extend.StudyDate), where.SelectEndTime);
                }
                if (where.ID > 0)
                {
                    sb.AppendFormat(" and tc.ID={0}", where.ID);
                }
            }
            return Get<RB_Point_TeacherCourse_Extend>(sb.ToString()).ToList();
        }




        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_Point_TeacherCourse_Extend> GetTeacherCoursePageList(int pageIndex, int pageSize, out long rowsCount, RB_Point_TeacherCourse_Extend where)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append($@"SELECT * from RB_Point_TeacherCourse  where state=0");
            if (where != null)
            {
                if (where.TenantId > 0)
                {
                    sb.AppendFormat(" and TenantId={0}", where.TenantId);
                }
                if (where.MallBaseId > 0)
                {
                    sb.AppendFormat(" and MallBaseId={0}", where.MallBaseId);
                }
                if (where.MallBaseId > 0)
                {
                    sb.AppendFormat(" and MallBaseId={0}", where.MallBaseId);
                }
                if (where.CourseClassId > 0)
                {
                    sb.AppendFormat(" and CourseClassId={0}", where.CourseClassId);
                }
                if (where.TeacherId > 0)
                {
                    sb.AppendFormat(" and TeacherId={0}", where.TeacherId);
                }
                if (!string.IsNullOrEmpty(where.SelectStartTime))
                {
                    sb.AppendFormat(" AND DATE_FORMAT(A.{0},'%y-%m-%d')>=DATE_FORMAT('{1}','%y-%m-%d') ", nameof(RB_Point_TeacherCourse_Extend.StudyDate), where.SelectStartTime);
                }
                if (!string.IsNullOrEmpty(where.SelectEndTime))
                {
                    sb.AppendFormat(" AND DATE_FORMAT(A.{0},'%y-%m-%d')<=DATE_FORMAT('{1}','%y-%m-%d') ", nameof(RB_Point_TeacherCourse_Extend.StudyDate), where.SelectEndTime);
                }
                if (where.ID > 0)
                {
                    sb.AppendFormat(" and ID={0}", where.ID);
                }
            }
            return GetPage<RB_Point_TeacherCourse_Extend>(pageIndex, pageSize, out rowsCount, sb.ToString()).ToList();
        }

        /// <summary>
        /// 获取分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_Point_TeacherCourse_Extend> GetPointTeacherCoursePageList(int pageIndex, int pageSize, out long count, RB_Point_TeacherCourse_Extend where)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append($@"SELECT tc.*,cc.CourseClassType,cc.StudentNumType,cc.IsPublic,cc.IsFree,o.ConfirmNum,o.OrderNum
from RB_Point_TeacherCourse as tc  
LEFT JOIN rb_point_courseclass as cc on tc.CourseClassId=cc.ID
left join (SELECT CourseId,SUM(case when OrderStaus =2 then 1 else 0 end) AS ConfirmNum,COUNT(0) AS OrderNum
 FROM rb_point_teachercourseorder WHERE State =0 and OrderStaus in (2,3,4) GROUP BY CourseId) o on tc.ID =o.CourseId
 where tc.state=0 and cc.state=0 ");
            if (where != null)
            {
                if (where.TenantId > 0)
                {
                    sb.AppendFormat(" and tc.TenantId={0}", where.TenantId);
                }
                if (where.MallBaseId > 0)
                {
                    sb.AppendFormat(" and tc.MallBaseId={0}", where.MallBaseId);
                }
                if (where.MallBaseId > 0)
                {
                    sb.AppendFormat(" and tc.MallBaseId={0}", where.MallBaseId);
                }
                if (where.CourseClassId > 0)
                {
                    sb.AppendFormat(" and tc.CourseClassId={0}", where.CourseClassId);
                }
                if (where.TeacherId > 0)
                {
                    sb.AppendFormat(" and tc.TeacherId={0}", where.TeacherId);
                }
                if (!string.IsNullOrEmpty(where.SelectStartTime))
                {
                    sb.AppendFormat(" AND DATE_FORMAT(tc.{0},'%y-%m-%d')>=DATE_FORMAT('{1}','%y-%m-%d') ", nameof(RB_Point_TeacherCourse_Extend.StudyDate), where.SelectStartTime);
                }
                if (!string.IsNullOrEmpty(where.SelectEndTime))
                {
                    sb.AppendFormat(" AND DATE_FORMAT(tc.{0},'%y-%m-%d')<=DATE_FORMAT('{1}','%y-%m-%d') ", nameof(RB_Point_TeacherCourse_Extend.StudyDate), where.SelectEndTime);
                }
                if (where.ID > 0)
                {
                    sb.AppendFormat(" and tc.ID={0}", where.ID);
                }
                if (where.CourseStudyState > 0) {
                    if (where.CourseStudyState == 1)
                    {
                        sb.AppendFormat(" AND CONCAT(DATE_FORMAT(StudyDate,'%Y-%m-%d'),' ',StudyEndDate) >= '{1}' ", DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss"));
                    }
                    else if (where.CourseStudyState == 2)
                    {
                        sb.AppendFormat(" AND CONCAT(DATE_FORMAT(StudyDate,'%Y-%m-%d'),' ',StudyEndDate) < '{1}' ", DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss"));
                    }
                }
            }
            return GetPage<RB_Point_TeacherCourse_Extend>(pageIndex, pageSize, out count, sb.ToString()).ToList();
        }
    }
}
