﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Model.Entity.Finance;
using Mall.Model.Extend.Finance;

namespace Mall.Repository.Finance
{
    /// <summary>
    /// 审核节点拷贝信息扩展表
    /// </summary>
    public  class Rb_Workflow_AuditRelevanceRepository : BaseRepository<Rb_Workflow_AuditRelevance>
    {
        /// <summary>
        /// 根据工作流id和模版类型获取所有审核流程
        /// </summary>
        /// <param name="WorkFlowId">工作流ID</param>
        /// <param name="FrIdStr"></param>
        /// <param name="status"></param>
        /// <returns></returns>
        public List<Rb_Workflow_AuditRelevance_Extend> GetAuditRelevanceList(int WorkFlowId, string FrIdStr = "", int? status = null)
        {
            string where = $@" where 1=1 ";
            if (WorkFlowId > 0)
            {
                where += $@" and ar.{nameof(Rb_Workflow_AuditRelevance.WorkFlowId) }={WorkFlowId}";
            }
            if (!string.IsNullOrWhiteSpace(FrIdStr))
            {
                where += $@" and ar.{nameof(Rb_Workflow_AuditRelevance.WorkFlowId) } in({FrIdStr})";
            }
            if (status != null)
            {
                where += $@" and ar.{nameof(Rb_Workflow_AuditRelevance.Stauts) }={(int)status}";
            }
            string sql = $@"SELECT ar.* from rb_workflow_auditrelevance ar {where} ORDER BY ar.Sort asc";
            return Get<Rb_Workflow_AuditRelevance_Extend>(sql).ToList();
        }

        /// <summary>
        /// 根据工作流ids获取所有审核流程
        /// </summary>
        /// <param name="FinanceIds"></param>
        /// <returns></returns>
        public List<Rb_Workflow_AuditRelevance_Extend> GetAuditRelevanceListForFIds(string FinanceIds)
        {
            string where = $@" where 1=1 and ar.{nameof(Rb_Workflow_AuditRelevance.Stauts)}=1";
            if (!string.IsNullOrWhiteSpace(FinanceIds))
            {
                where += $@" and ar.{nameof(Rb_Workflow_AuditRelevance.WorkFlowId) } in({FinanceIds})";
            }
            string sql = $@"SELECT ar.* from rb_workflow_auditrelevance ar {where} ORDER BY ar.Sort asc";
            return Get<Rb_Workflow_AuditRelevance_Extend>(sql).ToList();
        }

        /// <summary>
        /// 通过审核ID查询审核信息
        /// </summary>
        /// <param name="AuditIds"></param>
        /// <param name="FinanceAuditType">财务节点类型枚举</param>
        /// <returns></returns>
        public List<Rb_Workflow_AuditRelevance_Extend> GetAuditRelevanceList(string AuditIds, int FinanceAuditType = 0)
        {
            string where = $@" where 1=1 ";
            if (!string.IsNullOrEmpty(AuditIds))
            {
                where += $@" and ar.{nameof(Rb_Workflow_AuditRelevance.Id) } in ({AuditIds})";
            }
            if (FinanceAuditType > 0)
            {
                where += $@" and ar.{nameof(Rb_Workflow_AuditRelevance.SpecialNode) }= ({(int)FinanceAuditType})";
            }
            string sql = $@"SELECT ar.* from rb_workflow_auditrelevance ar {where} ORDER BY ar.Sort asc";
            return Get<Rb_Workflow_AuditRelevance_Extend>(sql).ToList();
        }

    }
}
