﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Miai;
using Mall.Model.Extend.Miai;
using System.Linq;

namespace Mall.Repository.Miai
{
    /// <summary>
    /// 相亲消息仓储层
    /// </summary>
    public class RB_Miai_MessageRepository : BaseRepository<RB_Miai_Message>
    {

        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Miai_Message_Extend> GetPageList(int pageIndex, int pageSize, out long rowCount, RB_Miai_Message_Extend dmodel)
        {
            string where = $" 1=1 ";
            if (dmodel.Status >= 0)
            {
                where += $@" and {nameof(RB_Miai_Message_Extend.Status)}={dmodel.Status}";
            }
            if (dmodel.TenantId > 0) {
                where += $@" and {nameof(RB_Miai_Message_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Miai_Message_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and {nameof(RB_Miai_Message_Extend.UserId)} ={dmodel.UserId}";
            }
            if (dmodel.CreateBy > 0)
            {
                where += $@" and {nameof(RB_Miai_Message_Extend.CreateBy)} ={dmodel.CreateBy}";
            }
            if (dmodel.Type > 0)
            {
                where += $@" and {nameof(RB_Miai_Message_Extend.Type)} ={(int)dmodel.Type}";
            }
            if (dmodel.SelectType > 0)
            {
                switch (dmodel.SelectType)
                {
                    case 1:
                        where += $@" and Type in (1,2)";
                        break;
                    case 2:
                        where += $@" and Type in (3,4,5,6)";
                        break;
                    case 3:
                        where += $@" and Type in (7,10)";
                        break;
                    case 4:
                        where += $@" and Type in (8,9)";
                        break;
                }
            }

            string sql = $@"select * from RB_Miai_Message where {where} order by Id desc";
            return GetPage<RB_Miai_Message_Extend>(pageIndex, pageSize, out rowCount, sql).ToList();
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Miai_Message_Extend> GetList(RB_Miai_Message_Extend dmodel)
        {
            string where = $" 1=1 ";
            if (dmodel.Status >= 0)
            {
                where += $@" and {nameof(RB_Miai_Message_Extend.Status)}={dmodel.Status}";
            }
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Miai_Message_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Miai_Message_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and {nameof(RB_Miai_Message_Extend.UserId)} ={dmodel.UserId}";
            }
            if (dmodel.Type > 0)
            {
                where += $@" and {nameof(RB_Miai_Message_Extend.Type)} ={(int)dmodel.Type}";
            }

            string sql = $@"select * from RB_Miai_Message where {where} order by Id desc";
            return Get<RB_Miai_Message_Extend>(sql).ToList();
        }

        /// <summary>
        /// 批量清除
        /// </summary>
        /// <param name="type"></param>
        /// <param name="userId"></param>
        /// <returns></returns>
        public bool DelMiaiMessageInfoBatch(string type, int userId)
        {
            string sql = $@"update RB_Miai_Message set Status =1 where UserId ={userId}";
            if (!string.IsNullOrEmpty(type)) {
                sql += $@" and Type in({type})";
            }
            return Execute(sql) > 0;
        }

        /// <summary>
        /// 获取访客统计
        /// </summary>
        /// <param name="userId"></param>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public RB_Miai_Message_Extend GetMiaiMessageVisitorStatistics(int userId, int type, int tenantId, int mallBaseId)
        {
            if (type == 1)
            {
                //谁看过我的
                string sql = $@" SELECT 
(SELECT COUNT(0) FROM rb_miai_message WHERE `Status` =0 and UserId = {userId} and CreateDate >= '{DateTime.Now.ToString("yyyy-MM-dd")}' and CreateDate <= '{DateTime.Now.ToString("yyyy-MM-dd")} 23:59:59') AS TCount,
(SELECT COUNT(0) FROM (SELECT CreateBy FROM rb_miai_message WHERE `Status` =0 and UserId = {userId} and CreateDate >= '{DateTime.Now.ToString("yyyy-MM-dd")}' and CreateDate <= '{DateTime.Now.ToString("yyyy-MM-dd")} 23:59:59' GROUP BY CreateBy)t) AS PeopleNum ";
                return Get<RB_Miai_Message_Extend>(sql).FirstOrDefault();
            }
            else {
                //我看过谁的
                string sql = $@" SELECT 
(SELECT COUNT(0) FROM rb_miai_message WHERE `Status` =0 and CreateBy = {userId} and CreateDate >= '{DateTime.Now.ToString("yyyy-MM-dd")}' and CreateDate <= '{DateTime.Now.ToString("yyyy-MM-dd")} 23:59:59') AS TCount,
(SELECT COUNT(0) FROM (SELECT UserId FROM rb_miai_message WHERE `Status` =0 and CreateBy = {userId} and CreateDate >= '{DateTime.Now.ToString("yyyy-MM-dd")}' and CreateDate <= '{DateTime.Now.ToString("yyyy-MM-dd")} 23:59:59' GROUP BY UserId)t) AS PeopleNum ";
                return Get<RB_Miai_Message_Extend>(sql).FirstOrDefault();
            }
        }

        /// <summary>
        /// 获取消息数量
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public int GetMessageNum(RB_Miai_Message_Extend dmodel)
        {
            string where = $" 1=1 ";
            if (dmodel.Status >= 0)
            {
                where += $@" and {nameof(RB_Miai_Message_Extend.Status)}={dmodel.Status}";
            }
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Miai_Message_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Miai_Message_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and {nameof(RB_Miai_Message_Extend.UserId)} ={dmodel.UserId}";
            }
            if (dmodel.Type > 0)
            {
                where += $@" and {nameof(RB_Miai_Message_Extend.Type)} ={(int)dmodel.Type}";
            }
            if (dmodel.SelectType > 0)
            {
                switch (dmodel.SelectType)
                {
                    case 1:
                        where += $@" and Type in (1,2)";
                        break;
                    case 2:
                        where += $@" and Type in (3,4,5,6)";
                        break;
                    case 3:
                        where += $@" and Type in (7,10)";
                        break;
                    case 4:
                        where += $@" and Type in (8,9)";
                        break;
                }
            }

            string sql = $@"select count(0) from RB_Miai_Message where {where} ";
            var obj = ExecuteScalar(sql);
            return obj == null ? 0 : Convert.ToInt32(obj);
        }

        /// <summary>
        /// 获取最新的一条记录
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public RB_Miai_Message_Extend GetNewMessageInfo(RB_Miai_Message_Extend dmodel) {
            string where = $" 1=1 ";
            if (dmodel.Status >= 0)
            {
                where += $@" and {nameof(RB_Miai_Message_Extend.Status)}={dmodel.Status}";
            }
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Miai_Message_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Miai_Message_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and {nameof(RB_Miai_Message_Extend.UserId)} ={dmodel.UserId}";
            }
            if (dmodel.Type > 0)
            {
                where += $@" and {nameof(RB_Miai_Message_Extend.Type)} ={(int)dmodel.Type}";
            }
            if (dmodel.SelectType > 0)
            {
                switch (dmodel.SelectType)
                {
                    case 1:
                        where += $@" and Type in (1,2)";
                        break;
                    case 2:
                        where += $@" and Type in (3,4,5,6)";
                        break;
                    case 3:
                        where += $@" and Type in (7,10)";
                        break;
                    case 4:
                        where += $@" and Type in (8,9)";
                        break;
                }
            }

            string sql = $@"select * from RB_Miai_Message where {where} order by Id desc limit 1";
            return Get<RB_Miai_Message_Extend>(sql).FirstOrDefault();
        }
    }
}
