﻿using Mall.Common.AOP;
using Mall.Common.Enum.MallBase;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.BaseSetUp
{
    /// <summary>
    /// 文件上传位置
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_File_Store
    {

        public int ID { get; set; }

        /// <summary>
        /// 商户id
        /// </summary>
        public int TenantId { get; set; }

        /// <summary>
        /// 小程序id
        /// </summary>
        public int MallBaseId { get; set; }

        /// <summary>
        /// 0-否1-是
        /// </summary>
        public int IsDefault { get; set; }

        public int Status { get; set; }

        public DateTime CreateDate { get; set; }
        public DateTime UpdateDate { get; set; }

        /// <summary>
        /// 空间名称
        /// </summary>
        public string Bucket { get; set; }

        /// <summary>
        /// 存储位置，1-腾讯云，2-七牛，3-其他
        /// </summary>
        public StoreTypeEnum StoreType { get; set; }

        /// <summary>
        /// 所属区域
        /// </summary>
        public string Region { get; set; }

        /// <summary>
        /// 自定义域名
        /// </summary>
        public string CustomDomain { get; set; }


        /// <summary>
        /// 自定义域名
        /// </summary>
        public string SecretKey { get; set; }
        /// <summary>
        /// 自定义域名
        /// </summary>
        public string SecretId { get; set; }
        /// <summary>
        /// 图片样式接口（七牛）
        /// </summary>
        public string ImgStyle { get; set; }

    }
}
