﻿using Mall.Model.Extend.MarketingCenter;
using Mall.Repository.MarketingCenter;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Module.MarketingCenter
{
    public class RechargeModule
    {
        private RB_Recharge_RulesRepository rulesRepository = new RB_Recharge_RulesRepository();


        #region 充值信息
        /// <summary>
        /// 充值信息列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Recharge_Rules_Extend> GetRechargeRulesPageList(int pageIndex, int pageSize, out long rowCount, RB_Recharge_Rules_Extend query)
        {
            return rulesRepository.GetRechargeRulesPageList(pageIndex, pageSize, out rowCount, query);
        }


        /// <summary>
        /// 充值信息列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Recharge_Rules_Extend> GetRechargeRulesList(RB_Recharge_Rules_Extend query)
        {
            return rulesRepository.GetRechargeRulesList(query);
        }


        public bool AddOrUpdateRechargeRules(RB_Recharge_Rules_Extend model)
        {
            if (model.ID == 0)
            {
                return rulesRepository.Insert(model) > 0;
            }
            else
            {
                return rulesRepository.Update(model);
            }
        }

        #endregion

    }
}
