﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Common;
using Mall.Common.Plugin;
using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using Mall.Repository;
using Mall.Repository.User;
using Mall.Repository.Product;
using Mall.Model.Extend.Product;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.Configuration.Json;

namespace Mall.Module.User
{
    /// <summary>
    /// 商户用户公共处理层
    /// </summary>
    public class UserCommonModule
    {
        /// <summary>
        /// 分销基础配置
        /// </summary>
        private readonly RB_Distributor_BasicsRepository distributor_BasicsRepository = new RB_Distributor_BasicsRepository();
        /// <summary>
        /// 分销自定义设置
        /// </summary>
        private readonly RB_Distributor_CustomRepository distributor_CustomRepository = new RB_Distributor_CustomRepository();

        /// <summary>
        /// 初始化分销基础配置
        /// </summary>
        /// <param name="TenantId"></param>
        /// <param name="MallBaseId"></param>
        /// <returns></returns>
        public bool InitializeDistributorBasicsInfo(int TenantId,int MallBaseId)
        {
            var OModel = distributor_BasicsRepository.GetList(new RB_Distributor_Basics_Extend() { TenantId = TenantId, MallBaseId = MallBaseId }).FirstOrDefault();
            if (OModel == null)
            {
                string GradeEntranceImage = new ConfigurationBuilder().Add(new JsonConfigurationSource { Path = "appsettings.json" }).Build().GetSection("InitializeImages")["GradeEntranceImage"];
                return distributor_BasicsRepository.Insert(new RB_Distributor_Basics()
                {
                    Id = 0,
                    ApplicationProtocol = "",
                    ApplyFor = Common.Enum.User.DistributorApplyForEnum.TX,
                    BackgroundImage = 0,
                    CreateDate = DateTime.Now,
                    DailyWithdrawalLimit = -1,
                    DistributorCommissionType = 1,
                    DistributorCondition = Common.Enum.User.DistributorConditionEnum.WTJ,
                    DistributorTier = 1,
                    GradeEntrance = 1,
                    GradeEntranceImage = GradeEntranceImage,
                    IndexImage = 0,
                    InPurchasing = 1,
                    MallBaseId = MallBaseId,
                    MinimumWithdrawalLimit = 50,
                    OneCommission = 0,
                    ReferralsCondition = Common.Enum.User.DistrbutorReferralsEnum.SCDJ,
                    TenantId = TenantId,
                    ThreeCommission = 0,
                    TwoCommission = 0,
                    UpdateDate = DateTime.Now,
                    UserNotes = "",
                    WithdrawFee = 0,
                    WithdrawWay = Common.Enum.User.DistrbutorWithdrawWayEnum.ZDDK,
                    IsCommissionResidue = 2
                }) > 0;
            }
            else {
                return true;
            }
        }

        /// <summary>
        /// 初始化分销自定义
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public bool InitializeDistributorCustomInfo(int TenantId, int MallBaseId)
        {
            var OModel = distributor_CustomRepository.GetList(new RB_Distributor_Custom_Extend() { TenantId = TenantId, MallBaseId = MallBaseId }).FirstOrDefault();
            if (OModel != null)
            {
                return distributor_CustomRepository.Insert(new RB_Distributor_Custom()
                {
                    Id = 0,
                    ApplicationAgreement = "分销申请协议",
                    HeadImage = 1,
                    BottomImage = 2,
                    ButtonColor = "#FF4544",
                    ButtonFilletPX = 40,
                    ButtonText = "申请成为分销商",
                    ButtonTextColor = "#FFFFFF",
                    DistributionApplication = "分销申请",
                    DistributionCommissionName = "分销佣金",
                    DistributionCommissionImage = 3,
                    DistributionOrderName = "分销订单",
                    DistributionOrderImage = 4,
                    WithdrawDetialsName = "提现明细",
                    WithdrawDetialsImage = 5,
                    MyTeamName = "我的团队",
                    MyTeamImage = 6,
                    PromoteQRCodeName = "推广二维码",
                    PromoteQRCodeImage = 7,
                    ReferrerName = "推荐人",
                    CommissionForWithdrawalName = "可提现佣金",
                    WithdrawDepositName = "提现",
                    CommissionWithdrawnName = "已提现佣金",
                    OutstandingCommissionName = "未结算佣金",
                    DistributorName = "分销商",
                    CommissionTobePaidName = "待打款佣金",
                    UserNotesName = "用户须知",
                    IWantToWithdrawName = "我要提现",
                    WithdrawalAmountName = "提现金额",
                    WithdrawalWayName = "提现方式",
                    OneDistributionName = "一级分销名称",
                    TwoDistributionName = "二级分销名称",
                    ThreeDistributionName = "三级分销名称",
                    CreateDate = DateTime.Now,
                    MallBaseId = MallBaseId,
                    TenantId = TenantId,
                    UpdateDate = DateTime.Now
                }) > 0;
            }
            else {
                return true;
            }
        }
    }
}
