﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using System.Linq;

namespace Mall.Repository.User
{
    /// <summary>
    /// 用户积分仓储层
    /// </summary>
    public class RB_Member_IntegralRepository : RepositoryBase<RB_Member_Integral>
    {

        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Member_Integral_Extend> GetPageList(int pageIndex, int pageSize, out long rowCount, RB_Member_Integral_Extend dmodel)
        {
            string where = " 1=1 ";
            if (dmodel.TenantId > 0) {
                where += $@" and {nameof(RB_Member_Integral.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0) {
                where += $@" and {nameof(RB_Member_Integral.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0) {
                where += $@" and {nameof(RB_Member_Integral.Id)}={dmodel.Id}";
            }
            if (dmodel.Type > 0) {
                where += $@" and {nameof(RB_Member_Integral.Type)}={dmodel.Type}";
            }
            if (dmodel.UserId > 0) {
                where += $@" and {nameof(RB_Member_Integral.UserId)}={dmodel.UserId}";
            }

            string sql = $@"select * from RB_Member_Integral where {where} order by Id desc";
            return GetPage<RB_Member_Integral_Extend>(pageIndex, pageSize, out rowCount, sql).ToList();
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Member_Integral_Extend> GetList(RB_Member_Integral_Extend dmodel)
        {
            string where = " 1=1 ";
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Member_Integral.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Member_Integral.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0)
            {
                where += $@" and {nameof(RB_Member_Integral.Id)}={dmodel.Id}";
            }
            if (dmodel.Type > 0)
            {
                where += $@" and {nameof(RB_Member_Integral.Type)}={dmodel.Type}";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and {nameof(RB_Member_Integral.UserId)}={dmodel.UserId}";
            }

            string sql = $@"select * from RB_Member_Integral where {where} order by Id desc";
            return Get<RB_Member_Integral_Extend>(sql).ToList();
        }
    }
}
