﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Mall.Common.API;
using Mall.Model.Extend.Product;
using Mall.Module.User;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Mall.Common.Plugin;
using Mall.Common.Enum.User;
using Mall.CacheManager.User;
using Newtonsoft.Json.Linq;
using Mall.Common;
using Mall.Module.Product;

namespace Mall.WebApi.Controllers.MallBase
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class ProductController : BaseController
    {

        private readonly ProductModule productModule = new ProductModule();

        #region 素材管理
        /// <summary>
        /// 获取素材分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetMaterialInfoPageList()
        {
            var parms = RequestParm;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(parms.msg.ToString());
            RB_Material_Info_Extend demodel = JsonConvert.DeserializeObject<RB_Material_Info_Extend>(parms.msg.ToString());

            demodel.TenantId = Convert.ToInt32(parms.uid);
            var list = productModule.GetMaterialInfoPageList(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list.Select(x => new
            {
                x.Id,
                x.Name,
                x.Type,
                x.GroupId,
                x.Path,
                x.Image,
                x.VideoTime,
                x.WithHeight,
                x.Recycled,
                x.TenantId,
                x.MallBaseId,
                CreateDate = x.CreateDate.HasValue ? x.CreateDate.Value.ToString("yyyy-MM-dd") : ""
            });
            return ApiResult.Success("", pagelist);
        }

        /// <summary>
        /// 新增素材信息
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetMaterialInfo() {
            var parms = RequestParm;
            RB_Material_Info_Extend demodel = JsonConvert.DeserializeObject<RB_Material_Info_Extend>(parms.msg.ToString());
            if (string.IsNullOrEmpty(demodel.Name))
            {
                return ApiResult.ParamIsNull("请输入分组名称");
            }
            if (demodel.Type != 1 && demodel.Type != 2)
            {
                return ApiResult.ParamIsNull("请传递类型");
            }
            if ((demodel.GroupId ?? 0) < 0) {
                return ApiResult.ParamIsNull("请输入分组");
            }
            if (string.IsNullOrEmpty(demodel.Path)) {
                return ApiResult.ParamIsNull("请传递文件路径");
            }

            demodel.Path = Config.GetFilePath(demodel.Path);
            demodel.Image = Config.GetFilePath(demodel.Image);
            demodel.TenantId = Convert.ToInt32(parms.uid);
            demodel.MallBaseId = parms.MallBaseId;
            demodel.CreateDate = DateTime.Now;
            demodel.UpdateDate = DateTime.Now;
            demodel.Status = 0;
            demodel.Recycled = 1;
            bool flag = productModule.SetMaterialInfo(demodel);
            if (flag)
            {
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed();
            }
        }

        /// <summary>
        /// 获取素材分组列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetMaterialGroupList()
        {
            var parms = RequestParm;
            RB_Material_Group_Extend demodel = JsonConvert.DeserializeObject<RB_Material_Group_Extend>(parms.msg.ToString());

            demodel.TenantId = Convert.ToInt32(parms.uid);
            var list = productModule.GetMaterialGroupList(demodel);
            return ApiResult.Success("", list.Select(x => new
            {
                x.Id,
                x.Name,
                x.Type,
                x.Sort,
                x.Recycled,
                x.TenantId,
                x.MallBaseId,
                CreateDate = x.CreateDate.HasValue ? x.CreateDate.Value.ToString("yyyy-MM-dd") : ""
            }));
        }

        /// <summary>
        /// 新增修改分组
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetMaterialGroupInfo() {
            var parms = RequestParm;
            RB_Material_Group_Extend demodel = JsonConvert.DeserializeObject<RB_Material_Group_Extend>(parms.msg.ToString());
            if (string.IsNullOrEmpty(demodel.Name)) {
                return ApiResult.ParamIsNull("请输入分组名称");
            }
            if (demodel.Type != 1 && demodel.Type != 2) {
                return ApiResult.ParamIsNull("请传递类型");
            }

            demodel.TenantId = Convert.ToInt32(parms.uid);
            demodel.MallBaseId = parms.MallBaseId;
            demodel.CreateDate = DateTime.Now;
            demodel.UpdateDate = DateTime.Now;
            demodel.Status = 0;
            demodel.Recycled = 1;
            bool flag = productModule.SetMaterialGroupInfo(demodel);
            if (flag)
            {
                return ApiResult.Success();
            }
            else {
                return ApiResult.Failed();
            }
        }

        /// <summary>
        /// 设置分组回收
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetMaterialGroupRecycled() {
            var requestParm = RequestParm;
            var parms = JObject.Parse(requestParm.msg.ToString());
            int GroupId = parms.GetInt("GroupId", 0);
            if (GroupId < 0) {
                return ApiResult.ParamIsNull("请传递分组id");
            }

            bool flag = productModule.SetMaterialGroupRecycled(GroupId, requestParm.uid, requestParm.MallBaseId);
            if (flag)
            {
                return ApiResult.Success();
            }
            else {
                return ApiResult.Failed();
            }
        }

        /// <summary>
        /// 删除分组信息
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult DelMaterialGroupInfo()
        {
            var requestParm = RequestParm;
            var parms = JObject.Parse(requestParm.msg.ToString());
            int GroupId = parms.GetInt("GroupId", 0);
            if (GroupId < 0)
            {
                return ApiResult.ParamIsNull("请传递分组id");
            }

            bool flag = productModule.DelMaterialGroupInfo(GroupId, requestParm.uid, requestParm.MallBaseId);
            if (flag)
            {
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed();
            }
        }

        /// <summary>
        /// 设置分组还原
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetMaterialGroupRestore()
        {
            var requestParm = RequestParm;
            var parms = JObject.Parse(requestParm.msg.ToString());
            int GroupId = parms.GetInt("GroupId", 0);
            if (GroupId < 0)
            {
                return ApiResult.ParamIsNull("请传递分组id");
            }

            bool flag = productModule.SetMaterialGroupRestore(GroupId, requestParm.uid, requestParm.MallBaseId);
            if (flag)
            {
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed();
            }
        }


        /// <summary>
        /// 设置素材回收
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetMaterialInfoRecycled()
        {
            var requestParm = RequestParm;
            var parms = JObject.Parse(requestParm.msg.ToString());
            string MaterialIds = parms.GetStringValue("MaterialIds");
            if (string.IsNullOrEmpty(MaterialIds))
            {
                return ApiResult.ParamIsNull("请传递素材ids");
            }

            bool flag = productModule.SetMaterialInfoRecycled(MaterialIds, requestParm.uid, requestParm.MallBaseId);
            if (flag)
            {
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed();
            }
        }

        /// <summary>
        /// 删除素材信息
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult DelMaterialInfo()
        {
            var requestParm = RequestParm;
            var parms = JObject.Parse(requestParm.msg.ToString());
            string MaterialIds = parms.GetStringValue("MaterialIds");
            if (string.IsNullOrEmpty(MaterialIds))
            {
                return ApiResult.ParamIsNull("请传递素材ids");
            }

            bool flag = productModule.DelMaterialInfo(MaterialIds, requestParm.uid, requestParm.MallBaseId);
            if (flag)
            {
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed();
            }
        }

        /// <summary>
        /// 设置素材还原
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetMaterialInfoRestore()
        {
            var requestParm = RequestParm;
            var parms = JObject.Parse(requestParm.msg.ToString());
            string MaterialIds = parms.GetStringValue("MaterialIds");
            if (string.IsNullOrEmpty(MaterialIds))
            {
                return ApiResult.ParamIsNull("请传递素材ids");
            }

            bool flag = productModule.SetMaterialInfoRestore(MaterialIds, requestParm.uid, requestParm.MallBaseId);
            if (flag)
            {
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed();
            }
        }

        /// <summary>
        /// 设置素材转移
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetMaterialInfoTransfer()
        {
            var requestParm = RequestParm;
            var parms = JObject.Parse(requestParm.msg.ToString());
            string MaterialIds = parms.GetStringValue("MaterialIds");
            int GroupId = parms.GetInt("GroupId", 0);
            int Type = parms.GetInt("Type", 0);
            if (string.IsNullOrEmpty(MaterialIds))
            {
                return ApiResult.ParamIsNull("请传递素材ids");
            }
            if (GroupId <= 0) 
            {
                return ApiResult.ParamIsNull("请传递分组id");
            }

            bool flag = productModule.SetMaterialInfoTransfer(MaterialIds, GroupId, Type, requestParm.uid, requestParm.MallBaseId);
            if (flag)
            {
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed();
            }
        }

        #endregion
    }
}