﻿using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;

namespace Mall.Model.Entity.User
{
    /// <summary>
    /// 小程序实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_WeChatPublicAccount
    {
        public int ID { get; set; }

        /// <summary>
        /// 小程序主键Id
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }

        /// <summary>
        /// 商户号
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }


        public string Token { get; set; }

        public string EncodingAESKey { get; set; }


        public string AppId { get; set; }


        public string Appsecret { get; set; }

        /// <summary>
        /// Openid  多个英文逗号隔开 ("1,2,3")
        /// </summary>
        public string Openids { get; set; }

        /// <summary>
        /// 下单成功提醒(类目:服装/鞋/箱包)
        /// </summary>        
        public string OrderSuccessTpl
        {
            get;
            set;
        }

        /// <summary>
        /// 订单取消提醒(类目:服装/鞋/箱包)
        /// </summary>        
        public string OrderCancelTpl
        {
            get;
            set;
        }


        /// <summary>
        /// 创建时间
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }

        /// <summary>
        /// 状态(0-正常，1-禁用)
        /// </summary>
        public int Status { get; set; }
    }
}
