﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Mall.Common.API;
using Mall.Common.Plugin;
using Mall.Model.Extend.TradePavilion;
using Mall.Module.TradePavilion;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;

namespace Mall.WebApi.Controllers.TradePavilion
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class AppletTradeController : BaseController
    {
        /// <summary>
        /// 联系人处理类对象
        /// </summary>
        private readonly ContractModule module = new ContractModule();

        /// <summary>
        /// 投资采购处理类对象
        /// </summary>
        private readonly InvestmentProcurementModule procurementModule = new InvestmentProcurementModule();

        /// <summary>
        /// 公司信息处理类对象
        /// </summary>
        private readonly CompanyModule companyModule = new CompanyModule();


        /// <summary>
        /// 商会活动处理类对象
        /// </summary>
        private readonly CommerceActivityModule activityModule = new CommerceActivityModule();

        /// <summary>
        /// 商会活动报名处理类对象
        /// </summary>
        private readonly CommerceConsultModule consultModule = new CommerceConsultModule();

        /// <summary>
        /// 新闻处理类对象
        /// </summary>
        private readonly CommerceNewsModule commerceNewsModule = new CommerceNewsModule();

        /// <summary>
        /// 新增修改公司信息
        /// </summary>
        /// <returns></returns>
        public ApiResult SetCompany()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var extModel = new RB_Company_Extend()
            {
                CompanyId = parms.GetInt("CompanyId"),
                CompanyName = parms.GetStringValue("CompanyName"),
                CompanyEnName = parms.GetStringValue("CompanyEnName"),
                Principal = parms.GetStringValue("Principal"),
                Mobile = parms.GetStringValue("Mobile"),
                EMail = parms.GetStringValue("EMail"),
                LegalPerson = parms.GetStringValue("LegalPerson"),
                WechatNo = parms.GetStringValue("WechatNo"),
                CompanyIntro = parms.GetStringValue("CompanyIntro"),
                DomainUrl = parms.GetStringValue("DomainUrl"),
                FoundingTime = parms.GetDateTime("FoundingTime"),
                EmployeeNum = parms.GetInt("EmployeeNum"),
                AnnualSales = parms.GetDecimal("AnnualSales"),
                AnnualImport = parms.GetDecimal("AnnualImport"),
                Address = parms.GetStringValue("Address"),
                EnAddress = parms.GetStringValue("EnAddress"),
                Industry = parms.GetStringValue("Industry"),
                ExportCountry = parms.GetStringValue("ExportCountry"),
                ImportCountry = parms.GetStringValue("ImportCountry"),
                ImportCategory = parms.GetStringValue("ImportCategory"),
                OtherInfo = parms.GetStringValue("OtherInfo"),
            };
            var userInfo = AppletUserInfo;
            extModel.Status = Common.Enum.DateStateEnum.Normal;
            extModel.MallBaseId = userInfo.MallBaseId;
            extModel.TenantId = userInfo.TenantId;
            Int32.TryParse(userInfo.UserId.ToString(), out int Uid);
            extModel.CreateBy = Uid;
            extModel.CreateDate = DateTime.Now;
            extModel.UpdateBy = Uid;
            extModel.UpdateDate = DateTime.Now;
            var flag = companyModule.SetCompanyModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取当前用户的公司信息实体
        /// </summary>
        /// <returns></returns>
        public ApiResult GetUserCompany()
        {
            var userInfo = AppletUserInfo;
            var model = companyModule.GetCompanyByUserIdModule(userInfo.UserId);
            return ApiResult.Success(data: model);
        }

        /// <summary>
        /// 获取商会活动类型列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetCommerceActivityTypeList()
        {
            var query = new RB_Commerce_ActivityType_Extend();
            var userInfo = AppletUserInfo;
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = userInfo?.TenantId??0;
            var list = activityModule.GetCommerceActivityTypeListModule(query);
            return ApiResult.Success(data: list.Select(qitem=>new { qitem.Id,qitem.CoverImage,qitem.TypeName}));
        }

        /// <summary>
        /// 获取商会活动分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetCommerceActivityPage()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            JObject jObj = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Commerce_Activity_Extend()
            {
                 ActivityType= jObj.GetInt("ActivityType")
            };
            var userInfo = AppletUserInfo;
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = userInfo?.TenantId ?? 0;
            var list = activityModule.GetCommerceActivityPageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }


        /// <summary>
        /// 获取商会活动详情
        /// </summary>
        /// <returns></returns>
        public ApiResult GetCommerceActivity()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var extModel = activityModule.GetCommerceActivityModule(Id);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 新增修改商会活动报名
        /// </summary>
        /// <returns></returns>
        public ApiResult SetCommerceConsult()
        {
            JObject jObj = JObject.Parse(RequestParm.msg.ToString());
            var extModel = new RB_Commerce_Consult_Extend()
            {
                Id = jObj.GetInt("Id"),
                ActivityId = jObj.GetInt("ActivityId"),
                UserId = jObj.GetInt("UserId"),
                LinkMan = jObj.GetStringValue("LinkMan"),
                LinkTel = jObj.GetStringValue("LinkTel"),
            };
            var userInfo = AppletUserInfo;
            extModel.Status = Common.Enum.DateStateEnum.Normal;
            extModel.MallBaseId = RequestParm.MallBaseId;
            extModel.TenantId = userInfo?.TenantId ?? 0;
            extModel.UserId = userInfo?.UserId??0;
            extModel.CreateTime = DateTime.Now;
            var flag = consultModule.SetCommerceConsultModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取新闻前几条
        /// </summary>
        /// <returns></returns>
        public ApiResult GetNewsTop()
        {
            var userInfo = AppletUserInfo;
            var query = new RB_Commerce_News_Extend();
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = userInfo?.TenantId ?? 0;
            var list = commerceNewsModule.GetCommerceNewsTopListModule(5, query);
            return ApiResult.Success(data: list);
        }

        /// <summary>
        /// 获取新闻信息详情
        /// </summary>
        /// <returns></returns>
        public ApiResult GetCommerceNews()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var extModel = commerceNewsModule.GetCommerceNewsModule(Id);
            return ApiResult.Success(data: extModel);
        }

    }
}
