﻿using Mall.Common.Plugin;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Mall.Common.Enum.Goods
{
    /// <summary>
    /// 订单售后查询状态枚举
    /// </summary>
    public enum AfterSaleSelectStatusEnum
    {
        /// <summary>
        /// 待审核
        /// </summary>
        [EnumField("待审核")]
        Auditing = 1,
        /// <summary>
        /// 待买家处理
        /// </summary>
        [EnumField("待买家处理")]
        DeliveryToBuyer = 2,
        /// <summary>
        /// 待卖家处理
        /// </summary>
        [EnumField("待卖家处理")]
        ReceivedBySeller = 3,
        /// <summary>
        /// 已完成
        /// </summary>
        [EnumField("已完成")]
        RefundedBySeller = 4
    }
}
