﻿using Mall.Model.Entity.MarketingCenter;
using Mall.Model.Extend.MarketingCenter;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.MarketingCenter
{
    /// <summary>
    /// 自动发放优惠券仓储层
    /// </summary>
    public class RB_Coupon_SelfMotionRepository : RepositoryBase<RB_Coupon_SelfMotion>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_Coupon_SelfMotion); } }
        /// <summary>
        /// 自动发放优惠券规则列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Coupon_SelfMotion_Extend> GetSelfMotionPageLis(int pageIndex, int pageSize, out long rowCount, RB_Coupon_SelfMotion_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE  {nameof(RB_Coupon_SelfMotion_Extend.Status)}=0");
            if (query != null)
            {
                // where += $@" and {nameof(RB_Customer_InfoCreate.CustomerId)}={dmodel.CustomerId}";
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Coupon_SelfMotion_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Coupon_SelfMotion_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.DiscountCouponId > 0)
                {
                    builder.Append($" AND {nameof(RB_Coupon_SelfMotion_Extend.DiscountCouponId)}={query.DiscountCouponId}");
                }
            }
            return GetPage<RB_Coupon_SelfMotion_Extend>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }


        /// <summary>
        /// 自动发放优惠券规则列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Coupon_SelfMotion_Extend> GettRepositoryList(RB_Coupon_SelfMotion_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE {nameof(RB_Coupon_SelfMotion_Extend.Status)}=0 ");
            if (query != null)
            {
                if (query != null)
                {
                    // where += $@" and {nameof(RB_Customer_InfoCreate.CustomerId)}={dmodel.CustomerId}";
                    if (query.TenantId > 0)
                    {
                        builder.Append($" AND {nameof(RB_Coupon_SelfMotion_Extend.TenantId)}={query.TenantId}");
                    }
                    if (query.TenantId > 0)
                    {
                        builder.Append($" AND {nameof(RB_Coupon_SelfMotion_Extend.MallBaseId)}={query.MallBaseId}");
                    }
                    if (query.DiscountCouponId > 0)
                    {
                        builder.Append($" AND {nameof(RB_Coupon_SelfMotion_Extend.DiscountCouponId)}={query.DiscountCouponId}");
                    }
                }
            }
            return Get<RB_Coupon_SelfMotion_Extend>(builder.ToString()).ToList();
        }
    }
}
