﻿using Mall.Common.AOP;
using Mall.Common.Enum.Goods;
using Mall.Common.Enum.User;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.Product
{
    /// <summary>
    /// 商品表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Goods
    {

        /// <summary>
        /// Id
        /// </summary>        
        public int Id
        {
            get;
            set;
        }
        /// <summary>
        /// 商品名称
        /// </summary>        
        public string Name
        {
            get;
            set;
        }
        /// <summary>
        /// 轮播图  json 格式  第一张为封面图
        /// </summary>        
        public string CarouselImage
        {
            get;
            set;
        }
        /// <summary>
        /// 视频地址
        /// </summary>        
        public string VideoAddress
        {
            get;
            set;
        }
        /// <summary>
        /// 自定义分享标题
        /// </summary>        
        public string CustomShareTitles
        {
            get;
            set;
        }
        /// <summary>
        /// 自定义分享图片
        /// </summary>        
        public string CustomShareImage
        {
            get;
            set;
        }
        /// <summary>
        /// 商品状态   1销售中  2下架中
        /// </summary>        
        public int? GoodsStatus
        {
            get;
            set;
        }
        /// <summary>
        /// 库存数量
        /// </summary>        
        public int? InventoryNum
        {
            get;
            set;
        }
        /// <summary>
        /// 默认规格名
        /// </summary>        
        public string DefaultSpecificationName
        {
            get;
            set;
        }
        /// <summary>
        /// 是否自定义规格  1是  2否
        /// </summary>        
        public int? IsCustomSpecification
        {
            get;
            set;
        }
        /// <summary>
        /// 排序
        /// </summary>        
        public int? Sort
        {
            get;
            set;
        }
        /// <summary>
        /// 售价
        /// </summary>        
        public decimal? SellingPrice
        {
            get;
            set;
        }
        /// <summary>
        /// 原价
        /// </summary>        
        public decimal? OriginalPrice
        {
            get;
            set;
        }
        /// <summary>
        /// 单位
        /// </summary>        
        public string Unit
        {
            get;
            set;
        }
        /// <summary>
        /// 成本价格
        /// </summary>        
        public decimal? CostPrice
        {
            get;
            set;
        }
        /// <summary>
        /// 商品面议  1是  2否
        /// </summary>        
        public int? IsGoodsNegotiable
        {
            get;
            set;
        }
        /// <summary>
        /// 已售出数量
        /// </summary>        
        public int? SalesNum
        {
            get;
            set;
        }
        /// <summary>
        /// 商品货号
        /// </summary>        
        public string GoodsNumbers
        {
            get;
            set;
        }
        /// <summary>
        /// 商品重量   克
        /// </summary>        
        public int? GoodsWeight
        {
            get;
            set;
        }
        /// <summary>
        /// 是否默认服务  1是  2否
        /// </summary>        
        public int? IsDefaultService
        {
            get;
            set;
        }
        /// <summary>
        /// 商品服务  json格式
        /// </summary>        
        public string GoodsService
        {
            get;
            set;
        }
        /// <summary>
        /// 运费设置
        /// </summary>        
        public int? FreightId
        {
            get;
            set;
        }
        /// <summary>
        /// 自定义表单
        /// </summary>        
        public int? FormsId
        {
            get;
            set;
        }
        /// <summary>
        /// 限购商品数量
        /// </summary>        
        public int? LimitBuyGoodsNum
        {
            get;
            set;
        }
        /// <summary>
        /// 限购订单数量
        /// </summary>        
        public int? LimitBuyOrderNum
        {
            get;
            set;
        }
        /// <summary>
        /// 单品满件包邮
        /// </summary>        
        public int? FullNumPinkage
        {
            get;
            set;
        }
        /// <summary>
        /// 单品满额包邮
        /// </summary>        
        public decimal? FullMoneyPinkage
        {
            get;
            set;
        }
        /// <summary>
        /// 是否区域购买  1是  2否
        /// </summary>        
        public int? IsAreaBuy
        {
            get;
            set;
        }
        /// <summary>
        /// 积分赠送
        /// </summary>        
        public int? IntegralPresent
        {
            get;
            set;
        }
        /// <summary>
        /// 赠送类型  2固定值  1百分比
        /// </summary>        
        public int? IntegralPresentType
        {
            get;
            set;
        }
        /// <summary>
        /// 积分抵扣 
        /// </summary>        
        public decimal? PointsDeduction
        {
            get;
            set;
        }
        /// <summary>
        /// 抵扣类型  2固定值  1百分比
        /// </summary>        
        public int? PointsDeductionType
        {
            get;
            set;
        }
        /// <summary>
        /// 是否允许多件累计抵扣  1是  2否
        /// </summary>        
        public int? IsMultipleDeduction
        {
            get;
            set;
        }
        /// <summary>
        /// 商品详情
        /// </summary>        
        public string GoodsDetails
        {
            get;
            set;
        }
        /// <summary>
        /// 删除状态
        /// </summary>        
        public int? Status
        {
            get;
            set;
        }
        /// <summary>
        /// 商户号
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }
        /// <summary>
        /// 小程序id
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }
        /// <summary>
        /// CreateDate
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }
        /// <summary>
        /// UpdateDate
        /// </summary>        
        public DateTime? UpdateDate
        {
            get;
            set;
        }
        /// <summary>
        /// 是否开启单独分销   1是  2否
        /// </summary>        
        public int? SeparateDistribution
        {
            get;
            set;
        }
        /// <summary>
        /// 单独分销类型  1普通设置  2详细设置
        /// </summary>        
        public int? SeparateDistributionType
        {
            get;
            set;
        }
        /// <summary>
        /// 分销佣金类型   2固定金额   1百分比
        /// </summary>        
        public int? SeparateDistributionMoneyType
        {
            get;
            set;
        }
        /// <summary>
        /// 是否享受会员功能   1是  2否
        /// </summary>        
        public int? EnjoyMember
        {
            get;
            set;
        }
        /// <summary>
        /// 是否单独设置会员价  1是  2否
        /// </summary>        
        public int? SeparateSetMember
        {
            get;
            set;
        }
        /// <summary>
        /// 是否加入快速购买  1是  2否
        /// </summary>
        public int? IsQuickBuy { get; set; }
        /// <summary>
        /// 是否畅销  1是  2否
        /// </summary>
        public int? IsSellWell { get; set; }

        /// <summary>
        /// 商品类型
        /// </summary>
        public OrderTypeEnum? GoodsType { get; set; }



        /// <summary>
        /// 供应商id
        /// </summary>
        public int SupplierId { get; set; }
        /// <summary>
        /// 商品是否可代理  1是  2否
        /// </summary>
        public int? IsProxy { get; set; }
        /// <summary>
        /// 代理成本上浮类型  1百分比  2固定金额
        /// </summary>
        public int? ProxyType { get; set; }
        /// <summary>
        /// 价格上涨
        /// </summary>
        public decimal? ProxyRises { get; set; }
        /// <summary>
        /// 代理价格
        /// </summary>
        public decimal? ProxyMoney { get; set; }
        /// <summary>
        /// 是否是采购商品  1是  2否
        /// </summary>
        public int? IsProcurement { get; set; }
        /// <summary>
        /// 采购状态  1正常  2代理下架
        /// </summary>
        public int? ProcurementStatus { get; set; }


        /// <summary>
        /// 返佣总金额
        /// </summary>
        public decimal Commission { get; set; }

        /// <summary>
        /// 赠送粉象等级
        /// </summary>
        public int? PresentFXGrade { get; set; }
        /// <summary>
        /// 赠送的月份  几个月
        /// </summary>
        public int? PresentFXMonth { get; set; }
        /// <summary>
        /// 广告词
        /// </summary>
        public string Advertising { get; set; }
        /// <summary>
        /// 副标题
        /// </summary>
        public string SubName { get; set; }
    }
}
