﻿using Mall.Common.AOP;
using Mall.Common.Enum.Property;
using Mall.Model.Entity.Property;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Extend.Property
{
    /// <summary>
    /// 耗材盘点明细扩展实体
    /// </summary>    
    [Serializable]
    [DB(ConnectionName = "PropertyConnection")]
    public class RB_Supplies_CheckDetail_Extend : RB_Supplies_CheckDetail
    {

        /// <summary>
        /// 耗材名称
        /// </summary>
        public string SuppliesName { get; set; }
        /// <summary>
        /// 耗材编码
        /// </summary>
        public string SuppliesNo { get; set; }
        /// <summary>
        /// 规格json格式
        /// </summary>
        public string SpecificationName { get; set; }
        /// <summary>
        /// 耗材的规格
        /// </summary>
        public List<string> SpecificationList { get; set; }
        /// <summary>
        /// 图片列表
        /// </summary>
        public List<string> ImageList { get; set; }

        /// <summary>
        /// 查询盘亏盘盈  1是
        /// </summary>
        public int? IsSelectCheckLoss { get; set; }
        /// <summary>
        /// 只看有库存的
        /// </summary>
        public int? IsSelectHaveInventory { get; set; }
    }
}
