﻿namespace Mall.Repository
{
    /// <summary>
    /// WHERE帮助类
    /// </summary>
    public class WhereHelper
    {
        /// <summary>
        /// 默认构造函数
        /// </summary>
        public WhereHelper()
        {

        }

        /// <summary>
        /// 构造函数 默认为相等
        /// </summary>
        /// <param name="filedName">字段名称</param>
        /// <param name="filedValue">字段值</param>
        public WhereHelper(string filedName, object filedValue)
        {
            this.FiledName = filedName;
            this.FiledValue = filedValue;
            this.OperatorEnum = OperatorEnum.Equal;
        }

        /// <summary>
        /// 构造函数
        /// </summary>
        /// <param name="filedName">字段名称</param>
        /// <param name="filedValue">字段值</param>
        /// <param name="operatorEnum">操作符枚举</param>
        public WhereHelper(string filedName, object filedValue, OperatorEnum operatorEnum)
        {
            this.FiledName = filedName;
            this.FiledValue = FiledValue;
            this.OperatorEnum = operatorEnum;
        }

        /// <summary>
        /// 字段名称
        /// </summary>
        public string FiledName { get; set; }

        /// <summary>
        /// 字段值
        /// </summary>
        public object FiledValue { get; set; }

        /// <summary>
        /// 操作符
        /// </summary>
        public OperatorEnum OperatorEnum { get; set; }
    }

    /// <summary>
    /// 操作符枚举
    /// </summary>
    public enum OperatorEnum
    {
        /// <summary>
        /// 等于
        /// </summary>
        Equal = 0,

        /// <summary>
        /// 不等于
        /// </summary>
        NotEqual = 1,

        /// <summary>
        /// 大于
        /// </summary>
        MoreThan=2,

        /// <summary>
        /// 大于等于
        /// </summary>
        MoreThanEqual = 3,

        /// <summary>
        /// 小于
        /// </summary>
        LessThan=4,

        /// <summary>
        /// 小于等于
        /// </summary>
        LessThanEqual = 5,

        /// <summary>
        /// 包含
        /// </summary>
        IN=6,
    }
}
