﻿using Mall.Model.Entity.Property;
using Mall.Model.Extend.Property;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.Property
{
    /// <summary>
    /// 耗材盘点仓储类
    /// </summary>
    public partial class RB_Supplies_CheckRepository : RepositoryBase<RB_Supplies_Check>
    {
        /// <summary>
        /// 获取盘点分页数据
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="dmodel"></param>
        /// <param name="count"></param>
        /// <returns></returns>
        public List<RB_Supplies_Check_Extend> GetPageList(int pageIndex, int pageSize, RB_Supplies_Check_Extend dmodel, out long count)
        {
            string where = " where 1=1 ";
            where += string.Format(" AND {0}={1}", nameof(RB_Supplies_Check_Extend.Status), 0);
            where += $@" and RB_Group_Id={dmodel.RB_Group_Id}";
            if (dmodel.BranchId > -1)
            {
                where += " and " + nameof(RB_Supplies_Check_Extend.BranchId) + "=" + dmodel.BranchId;
            }
            if (!string.IsNullOrWhiteSpace(dmodel.Periods))
            {
                where += " and " + nameof(RB_Supplies_Check_Extend.Periods) + " like '%" + dmodel.Periods + "%'";
            }
            if (dmodel.WarehouseId > 0)
            {
                where += " and " + nameof(RB_Supplies_Check_Extend.WarehouseId) + "=" + dmodel.WarehouseId;
            }
            if (dmodel.CheckState > 0)
            {
                where += " and " + nameof(RB_Supplies_Check_Extend.CheckState) + "=" + (int)dmodel.CheckState;
            }
            string sql = $@" select * from RB_Supplies_Check {where} order by Id desc";
            return GetPage<RB_Supplies_Check_Extend>(pageIndex, pageSize, out count, sql).ToList();
        }

        /// <summary>
        /// 根据条件获取盘点列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Supplies_Check_Extend> GetList(RB_Supplies_Check_Extend dmodel)
        {
            string where = " where 1=1 ";
            where += string.Format(" AND {0}={1}", nameof(RB_Supplies_Check_Extend.Status), 0);
            where += $@" and RB_Group_Id={dmodel.RB_Group_Id}";
            if (dmodel.BranchId > -1)
            {
                where += " and " + nameof(RB_Supplies_Check_Extend.BranchId) + "=" + dmodel.BranchId;
            }
            if (!string.IsNullOrWhiteSpace(dmodel.Periods))
            {
                where += " and " + nameof(RB_Supplies_Check_Extend.Periods) + " like '%" + dmodel.Periods + "%'";
            }

            if (dmodel.StartDate.HasValue)
            {
                where += $" and  {nameof(RB_Supplies_Check_Extend.StartDate)} <='{dmodel.StartDate}' ";
            }
            if (dmodel.EndDate.HasValue)
            {
                where += $" and  {nameof(RB_Supplies_Check_Extend.StartDate)} >='{dmodel.EndDate}' ";
            }

      

            if (!string.IsNullOrWhiteSpace(dmodel.Periods))
            {
                where += " and " + nameof(RB_Supplies_Check_Extend.Periods) + " like '%" + dmodel.Periods + "%'";
            }
            if (dmodel.WarehouseId > 0)
            {
                where += " and " + nameof(RB_Supplies_Check_Extend.WarehouseId) + "=" + dmodel.WarehouseId;
            }
            if (dmodel.CheckState.HasValue && dmodel.CheckState > 0)
            {
                where += " and " + nameof(RB_Supplies_Check_Extend.CheckState) + "=" + (int)dmodel.CheckState;
            }
            string sql = $@" select * from RB_Supplies_Check {where} order by Id desc";
            return Get<RB_Supplies_Check_Extend>(sql).ToList();
        }
    }
}
