﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using System.Linq;

namespace Mall.Repository.User
{
    /// <summary>
    /// 用户收藏商品仓储层
    /// </summary>
    public class RB_Member_CollectionRepository : RepositoryBase<RB_Member_Collection>
    {

        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Member_Collection_Extend> GetPageList(int pageIndex, int pageSize, out long rowCount, RB_Member_Collection_Extend dmodel)
        {
            string where = $" 1=1 and {nameof(RB_Member_Collection.Status)}=0 ";
            if (dmodel.TenantId > 0) {
                where += $@" and {nameof(RB_Member_Collection.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Member_Collection.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Type > 0) {
                where += $@" and {nameof(RB_Member_Collection.Type)} ={dmodel.Type}";
            }
            if (dmodel.UserId > 0) {
                where += $@" and {nameof(RB_Member_Collection.UserId)} ={dmodel.UserId}";
            }
            if (dmodel.GoodsId > 0)
            {
                where += $@" and {nameof(RB_Member_Collection.GoodsId)} ={dmodel.GoodsId}";
            }

            string sql = $@"select * from RB_Member_Collection where {where} order by Id desc";
            return GetPage<RB_Member_Collection_Extend>(pageIndex, pageSize, out rowCount, sql).ToList();
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Member_Collection_Extend> GetList(RB_Member_Collection_Extend dmodel)
        {
            string where = $" 1=1 and {nameof(RB_Member_Collection.Status)}=0 ";
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Member_Collection.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Member_Collection.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Type > 0)
            {
                where += $@" and {nameof(RB_Member_Collection.Type)} ={dmodel.Type}";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and {nameof(RB_Member_Collection.UserId)} ={dmodel.UserId}";
            }
            if (dmodel.GoodsId > 0)
            {
                where += $@" and {nameof(RB_Member_Collection.GoodsId)} ={dmodel.GoodsId}";
            }

            string sql = $@"select * from RB_Member_Collection where {where} order by Id desc";
            return Get<RB_Member_Collection_Extend>(sql).ToList();
        }

        /// <summary>
        /// 获取我的收藏数量
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public int GetMyCollectionNum(RB_Member_Collection_Extend dmodel)
        {
            string where = $" 1=1 and col.{nameof(RB_Member_Collection_Extend.Status)}=0";
            where += $" and col.Type=1 and col.UserId={dmodel.UserId} and g.Status=0 and g.GoodsStatus=1";
            if (dmodel.TenantId > 0)
            {
                where += $@" and col.{nameof(RB_Member_Collection_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and col.{nameof(RB_Member_Collection_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }

            string sql = $@"select count(0) from rb_member_collection col
inner join RB_Goods g on col.GoodsId=g.Id 
where {where} order by col.Id desc";
            var obj = ExecuteScalar(sql);
            if (obj != null)
            {
                return Convert.ToInt32(obj);
            }
            else {
                return 0;
            }
        }
    }
}
