﻿using Mall.Common.Plugin;
using Mall.Model.Entity.MarketingCenter;
using Mall.Model.Extend.MarketingCenter;
using Mall.Model.Extend.User;
using Mall.Repository;
using Mall.Repository.MarketingCenter;
using Mall.Repository.User;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Module.MarketingCenter
{
    public class RechargeModule
    {
        private RB_Recharge_RulesRepository rulesRepository = new RB_Recharge_RulesRepository();


        private RB_Member_BalanceRepository balanceRepository = new RB_Member_BalanceRepository();
        private RB_Recharge_SettingsRepository settingsRepository = new RB_Recharge_SettingsRepository();
        #region 充值规则信息
        /// <summary>
        /// 充值信息列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Recharge_Rules_Extend> GetRechargeRulesPageList(int pageIndex, int pageSize, out long rowCount, RB_Recharge_Rules_Extend query)
        {
            return rulesRepository.GetRechargeRulesPageList(pageIndex, pageSize, out rowCount, query);
        }


        /// <summary>
        /// 充值信息列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Recharge_Rules_Extend> GetRechargeRulesList(RB_Recharge_Rules_Extend query)
        {
            return rulesRepository.GetRechargeRulesList(query);
        }


        public bool AddOrUpdateRechargeRules(RB_Recharge_Rules_Extend model)
        {
            if (model.ID == 0)
            {
                return rulesRepository.Insert(model) > 0;
            }
            else
            {
                return rulesRepository.Update(model);
            }
        }


        /// <summary>
        /// 删除充值方案
        /// </summary>
        /// <param name="gradeId"></param>
        /// <param name="uid"></param>
        /// <returns></returns>
        public bool DelRechargeRules(int id, int uid, int mallBaseId)
        {
            try
            {
                Dictionary<string, object> cols = new Dictionary<string, object>()
                {
                    { nameof(RB_Recharge_Rules.Status),1},
                    { nameof(RB_Recharge_Rules.UpdateDate),DateTime.Now},
                };
                List<WhereHelper> wheres1 = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Recharge_Rules.ID),
                        FiledValue=id,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Recharge_Rules.TenantId),
                        FiledValue=Convert.ToInt32(uid),
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Recharge_Rules.MallBaseId),
                        FiledValue=Convert.ToInt32(mallBaseId),
                        OperatorEnum=OperatorEnum.Equal
                }
            };
                return rulesRepository.Update(cols, wheres1);

            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "DelRechargeRules");
                return false;
            }
        }

        #endregion


        #region 充值设置


        /// <summary>
        /// 充值设置列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Recharge_Settings> GetRechargeSettingsList(RB_Recharge_Settings query)
        {
            return settingsRepository.GetRechargeSettingsList(query);
        }

        public bool AddOrUpdateRechargeSettings(RB_Recharge_Settings model)
        {
            if (model.ID == 0)
            {
                return settingsRepository.Insert(model) > 0;
            }
            else
            {
                return settingsRepository.Update(model);
            }
        }
        #endregion

        #region 余额收支
        /// <summary>
        /// 营销中心-余额收支
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Member_Balance_Extend> GetMemberBalancePageList(int pageIndex, int pageSize, out long rowCount, RB_Member_Balance_Extend query)
        {
            return balanceRepository.GetMemberBalancePageList(pageIndex, pageSize, out rowCount, query);
        }




        /// <summary>
        /// 导出余额收支
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Member_Balance_Extend> GetMemberBalanceExport(RB_Member_Balance_Extend query)
        {
            return balanceRepository.GetMemberBalanceExport(query);
        }

        #endregion
    }
}
