﻿using System.Linq;
using Mall.Common.API;
using Microsoft.AspNetCore.Mvc;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Mall.Module.MarketingCenter;
using Newtonsoft.Json;
using Mall.Model.Query;
using System;
using Mall.Common.Plugin;
using System.Collections.Generic;
using Mall.Model.Extend.MarketingCenter;
using Newtonsoft.Json.Linq;
using Mall.Model.Entity.MarketingCenter;

namespace Mall.WebApi.Controllers.MarketingCenter
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class TemplateController : BaseController
    {
        /// <summary>
        /// 模板处理类
        /// </summary>
        private readonly Module.MarketingCenter.MiniprogramTemplateModule templateModule = new MiniprogramTemplateModule();

        /// <summary>
        /// 自定义页面处理类
        /// </summary>
        private readonly MiniprogramPageTemplModule miniprogramPageTemplModule = new MiniprogramPageTemplModule();

        #region 模板管理
        /// <summary>
        /// 新增修改小程序模板
        /// </summary>
        /// <returns></returns>
        public ApiResult SetMiniTemplate()
        {
            var extModel = JsonConvert.DeserializeObject<RB_Miniprogram_Template_Extend>(RequestParm.msg.ToString());
            extModel.TenantId = RequestParm.TenantId;
            extModel.MallBaseId = RequestParm.MallBaseId;
            if (extModel.ComponentDataList != null && extModel.ComponentDataList.Count > 0)
            {
                extModel.TemplateData = JsonConvert.SerializeObject(extModel.ComponentDataList);
            }
            Int32.TryParse(RequestParm.uid, out int Uid);
            extModel.CreateBy = Uid;
            extModel.CreateDate = DateTime.Now;
            extModel.Status = 0;
            var flag = templateModule.SetMiniprogramTemplateModule(extModel);
            return flag ? ApiResult.Success(data:extModel.Id) : ApiResult.Failed();
        }

        /// <summary>
        /// 获取小程序模板实体
        /// </summary>
        /// <returns></returns>
        public ApiResult GetMiniTemplate()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id");
            var result = templateModule.GetMiniprogramTemplateModule(Id);
            return ApiResult.Success(data: result);
        }

        /// <summary>
        /// 删除小程序模板
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveMiniTemplate()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var Status = parms.GetInt("Status", 1);
            var flag = templateModule.RemoveMiniprogramTemplateModule(Id, Status);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 小程序模板分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetMiniTemplatePageList()
        {
            var parms = RequestParm;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(parms.msg.ToString());
            var  query = JsonConvert.DeserializeObject<RB_Miniprogram_Template_Extend>(parms.msg.ToString());
            query.TenantId = Convert.ToInt32(parms.uid);
            query.MallBaseId = parms.MallBaseId;

            var list = templateModule.GetMiniprogramTemplatePageListModule(pagelist.pageIndex, pagelist.pageSize, out long count, query);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list;
            return ApiResult.Success("", pagelist);
        }
        #endregion

        #region 自定义页面管理

        /// <summary>
        /// 小程序自定义页面分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetMiniprogramPageTemplPageList()
        {
            var parms = RequestParm;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(parms.msg.ToString());
            var query = JsonConvert.DeserializeObject<RB_Miniprogram_Page_Templ_Extend>(parms.msg.ToString());
            query.TenantId = Convert.ToInt32(parms.uid);
            query.MallBaseId = parms.MallBaseId;

            var list = miniprogramPageTemplModule.GetMiniprogramPageTemplPageListModule(pagelist.pageIndex, pagelist.pageSize, out long count, query);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list;
            return ApiResult.Success("", pagelist);
        }

        /// <summary>
        /// 小程序自定义页面列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetMiniprogramPageTemplList()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<RB_Miniprogram_Page_Templ_Extend>(parms.msg.ToString());
            query.TenantId = Convert.ToInt32(parms.uid);
            query.MallBaseId = parms.MallBaseId;
            var list = miniprogramPageTemplModule.GetMiniprogramPageTemplListModule( query);
            return ApiResult.Success("", list);
        }

        /// <summary>
        /// 小程序自定义页面实体
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetMiniprogramPageTempl()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var query = JsonConvert.DeserializeObject<RB_Miniprogram_Page_Templ_Extend>(RequestParm.msg.ToString());
            query.TenantId = Convert.ToInt32(RequestParm.uid);
            query.MallBaseId = RequestParm.MallBaseId;
            bool isGetHome = parms.GetBoolValue("isGetHome");
            var extModel = miniprogramPageTemplModule.GetMiniprogramPageTemplModule(query,isGetHome: isGetHome);
            return ApiResult.Success("", extModel);
        }

        /// <summary>
        /// 新增修改自定义页面
        /// </summary>
        /// <returns></returns>
        public ApiResult SetMiniprogramPageTempl()
        {
            var extModel = JsonConvert.DeserializeObject<RB_Miniprogram_Page_Templ_Extend>(RequestParm.msg.ToString());
            extModel.TenantId = RequestParm.TenantId;
            extModel.MallBaseId = RequestParm.MallBaseId;
     
            Int32.TryParse(RequestParm.uid, out int Uid);
            extModel.CreateBy = Uid;
            extModel.CreateDate = DateTime.Now;
            extModel.Status = 0;
            var flag = miniprogramPageTemplModule.SetMiniprogramPageTemplModule(extModel);
            return flag ? ApiResult.Success(data: extModel.Id) : ApiResult.Failed();
        }

        /// <summary>
        /// 更新自定义页面状态
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveMiniprogramPageTempl()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var Status = parms.GetInt("Status", 1);
            var flag = miniprogramPageTemplModule.RemoveMiniprogramPageTemplModule(Id, Status);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 更新自定义页面状态
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveMiniprogramPageTemplDetails()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var flag = miniprogramPageTemplModule.RemoveMiniprogramPageTemplDetailsModule(Id);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }
        #endregion
    }
}