﻿using Mall.Common.Plugin;
using Mall.Model.Entity.MarketingCenter;
using Mall.Model.Entity.User;
using Mall.Model.Extend.MarketingCenter;
using Mall.Model.Extend.User;
using Mall.Model.Query;
using Mall.Repository;
using Mall.Repository.MarketingCenter;
using MySqlX.XDevAPI.Relational;
using Org.BouncyCastle.Crypto.Tls;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Module.MarketingCenter
{
    /// <summary>
    /// 小程序模板处理类
    /// </summary>
    public class MiniprogramTemplateModule
    {
        /// <summary>
        /// 小程序模板仓储层对象
        /// </summary>
        private readonly RB_Miniprogram_TemplateRepository miniprogram_TemplateRepository = new RB_Miniprogram_TemplateRepository();

        /// <summary>
        /// 小程序模板分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Miniprogram_Template_Extend> GetMiniprogramTemplatePageListModule(int pageIndex, int pageSize, out long rowCount, RB_Miniprogram_Template_Extend query)
        {
            return miniprogram_TemplateRepository.GetMiniprogramTemplatePageListRepository(pageIndex, pageSize, out rowCount, query);
        }


        /// <summary>
        /// 小程序模板列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Miniprogram_Template_Extend> GetMiniprogramTemplateListModule(RB_Miniprogram_Template_Extend query)
        {
            return miniprogram_TemplateRepository.GetMiniprogramTemplateListRepository(query);
        }

        /// <summary>
        /// 新增修改小程序模板
        /// </summary>
        /// <param name="extModel"></param>
        /// <returns></returns>
        public bool SetMiniprogramTemplateModule(RB_Miniprogram_Template_Extend extModel)
        {
            bool flag = false;
            if (extModel.Id > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_Miniprogram_Template_Extend.Id),extModel.Id }
                };
                fileds.Add(nameof(RB_Miniprogram_Template_Extend.TemplateName), extModel.TemplateName);
                fileds.Add(nameof(RB_Miniprogram_Template_Extend.TemplateData), extModel.TemplateData);
                flag = miniprogram_TemplateRepository.Update(fileds, new WhereHelper(nameof(RB_Miniprogram_Template_Extend.Id), extModel.Id));
            }
            else
            {
                var newId = miniprogram_TemplateRepository.Insert(extModel);
                extModel.Id = newId;
                flag = newId > 0;
            }
            return flag;
        }

        /// <summary>
        /// 获取小程序模板实体
        /// </summary>
        /// <param name="Id"></param>
        /// <returns></returns>
        public RB_Miniprogram_Template_Extend GetMiniprogramTemplateModule(object Id)
        {
            RB_Miniprogram_Template_Extend extModel = miniprogram_TemplateRepository.GetEntity<RB_Miniprogram_Template_Extend>(Id);
            if (extModel == null)
            {
                extModel = new RB_Miniprogram_Template_Extend();
            }
            return extModel;
        }

        /// <summary>
        /// 删除小程序模板
        /// </summary>
        /// <param name="Id"></param>
        /// <param name="Status"></param>
        /// <returns></returns>
        public bool RemoveMiniprogramTemplateModule(object Id, int Status)
        {
            bool flag = false;
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Miniprogram_Template_Extend.Status),Status }
            };
            flag = miniprogram_TemplateRepository.Update(fileds, new WhereHelper(nameof(RB_Miniprogram_Template_Extend.Id), Id));
            return flag;
        }
    }
}
