﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;
using Mall.Model.Extend.Product;
using System.Linq;
using Mall.Model.Entity.User;

namespace Mall.Repository.Product
{
    /// <summary>
    /// 商品订单返佣仓储层
    /// </summary>
    public class RB_Goods_OrderCommissionRepository : RepositoryBase<RB_Goods_OrderCommission>
    {

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Goods_OrderCommission_Extend> GetList(RB_Goods_OrderCommission_Extend dmodel)
        {
            string where = $" 1=1 ";
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Goods_OrderCommission.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Goods_OrderCommission.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.OrderId > 0)
            {
                where += $@" and {nameof(RB_Goods_OrderCommission.OrderId)}={dmodel.OrderId}";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and {nameof(RB_Goods_OrderCommission.UserId)}={dmodel.UserId}";
            }
            if (!string.IsNullOrEmpty(dmodel.OrderIds))
            {
                where += $@" and {nameof(RB_Goods_OrderCommission.OrderId)} in({dmodel.OrderIds})";
            }

            string sql = $@"SELECT * FROM RB_Goods_OrderCommission where {where} order by Id asc";
            return Get<RB_Goods_OrderCommission_Extend>(sql).ToList();
        }

        /// <summary>
        /// 获取用户返佣
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Goods_OrderCommission_Extend> GetListGroupByUser(RB_Goods_OrderCommission_Extend dmodel)
        {
            string where = $" 1=1 ";
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Goods_OrderCommission.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Goods_OrderCommission.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.OrderId > 0)
            {
                where += $@" and {nameof(RB_Goods_OrderCommission.OrderId)}={dmodel.OrderId}";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and {nameof(RB_Goods_OrderCommission.UserId)}={dmodel.UserId}";
            }
            if (!string.IsNullOrEmpty(dmodel.OrderIds))
            {
                where += $@" and {nameof(RB_Goods_OrderCommission.OrderId)} in({dmodel.OrderIds})";
            }

            string sql = $@"SELECT OrderId,UserId,Grade,SUM(Commission) as Commission FROM RB_Goods_OrderCommission where {where} group by OrderId,UserId,Grade order by Grade asc";
            return Get<RB_Goods_OrderCommission_Extend>(sql).ToList();
        }
    }
}
